// @(#)root/mathcore:$Id: Factory.cxx 21185 2007-12-04 14:56:12Z moneta $
// Author: L. Moneta Fri Dec 22 14:43:33 2006

/**********************************************************************
 *                                                                    *
 * Copyright (c) 2006  LCG ROOT Math Team, CERN/PH-SFT                *
 *                                                                    *
 *                                                                    *
 **********************************************************************/

// Implementation file for class MinimizerFactory

#include "Math/Factory.h"

#include "RConfigure.h"

#include "Math/Minimizer.h"

#ifndef MATH_NO_PLUGIN_MANAGER

// use PM 
#include "TPluginManager.h"
#include "TROOT.h"

#else 
// all the minimizer implementation classes 
#ifdef HAS_MINUIT2
#include "Minuit2/Minuit2Minimizer.h"
#endif
#ifdef HAS_MINUIT
#include "TMinuitMinimizer.h"
#endif
#ifdef R__HAS_MATHMORE
#include "Math/GSLMinimizer.h"
#include "Math/GSLNLSMinimizer.h"
#include "Math/GSLSimAnMinimizer.h"
#endif

#endif

#include <algorithm>

//#define DEBUG
#ifdef DEBUG
#include <iostream>
#endif

#ifndef MATH_NO_PLUGIN_MANAGER 
// use ROOT Plugin Manager to create Minimizer concrete classes 

ROOT::Math::Minimizer * ROOT::Math::Factory::CreateMinimizer(const std::string & minimizerType, const std::string & algoType)  
{
   // create Minimizer using the plug-in manager given the type of Minimizer (MINUIT, MINUIT2, FUMILI, etc..) and 
   // algorithm (MIGRAD, SIMPLEX, etc..)

   const char * minim = minimizerType.c_str();
   const char * algo = algoType.c_str();  

   std::string s1,s2;
   //case of fumili2
   if (minimizerType == "Fumili2" ) {
      s1 = "Minuit2";
      s2 = "fumili";
      minim = s1.c_str();
      algo =  s2.c_str();
   }

   // create Minimizer using the PM
   TPluginHandler *h; 
   //gDebug = 3; 
   if ((h = gROOT->GetPluginManager()->FindHandler("ROOT::Math::Minimizer",minim ))) {
      if (h->LoadPlugin() == -1)
         return 0;

      // create plug-in with required algorithm
      ROOT::Math::Minimizer * min = reinterpret_cast<ROOT::Math::Minimizer *>( h->ExecPlugin(1,algo ) ); 
#ifdef DEBUG
      std::cout << "Loaded Minimizer " << minimizerType << "  " << algoType << "  " << algo << std::endl;
#endif

      return min; 
   }
   return 0;
                                                                                          
}

#else 

// use directly classes instances 

ROOT::Math::Minimizer * ROOT::Math::Factory::CreateMinimizer(const std::string & minimizerType, const std::string & algoType)  
{
   // static method to create a minimizer . 
   // not using PM so direct dependency on all libraries (Minuit, Minuit2, MathMore, etc...)
   // The default is the Minuit2 minimizer or GSL Minimizer

   // should use enumerations instead of string ?  
   
   Minimizer * min = 0; 
   std::string algo = algoType; 


#ifdef HAS_MINUIT2
   if (minimizerType ==  "Minuit2")        
      min = new ROOT::Minuit2::Minuit2Minimizer(algoType.c_str()); 
   if (minimizerType ==  "Fumili2")        
      min = new ROOT::Minuit2::Minuit2Minimizer("fumili"); 
#endif

#ifdef HAS_MINUIT
   // use TMinuit
   if (minimizerType ==  "Minuit" || minimizerType ==  "TMinuit")        
      min = new ROOT::Fit::TMinuitMinimizer(algoType,c_str());        
#endif

#ifdef R__HAS_MATHMORE
   // use GSL minimizer 
   if (minimizerType ==  "GSL")        
      min = new ROOT::Math::GSLMinimizer(algoType.c_str());        

   else if (minimizerType ==  "GSL_NLS")        
      min = new ROOT::Math::GSLNLSMinimizer();        

   else if (minimizerType ==  "GSL_SIMAN")        
      min = new ROOT::Math::GSLSimAnMinimizer();        
#endif


#ifdef HAS_MINUIT2
   // DEFAULT IS MINUIT2 based on MIGRAD id minuit2 exists
   else
      min = new ROOT::Minuit2::Minuit2Minimizer(); 
#endif

   return min; 
}

#endif


