// @(#)root/gl:$Id: TGLPShapeObj.h 20882 2007-11-19 11:31:26Z rdm $
// Author:  Alja Mrak-Tadel  06/2006

/*************************************************************************
 * Copyright (C) 1995-2004, Rene Brun and Fons Rademakers.               *
 * All rights reserved.                                                  *
 *                                                                       *
 * For the licensing terms see $ROOTSYS/LICENSE.                         *
 * For the list of contributors see $ROOTSYS/README/CREDITS.             *
 *************************************************************************/

#ifndef ROOT_TGLPShapeObj
#define ROOT_TGLPShapeObj

#include <TObject.h>

class TGLPhysicalShape;
class TGLViewer;

class TGLPShapeObj : public TObject
{
public:
   TGLPhysicalShape *fPShape;
   TGLViewer        *fViewer;

   TGLPShapeObj() : TObject(), fPShape(0), fViewer(0) {}
   TGLPShapeObj(TGLPhysicalShape* sh, TGLViewer* v) :
      TObject(), fPShape(sh), fViewer(v) {}
   virtual ~TGLPShapeObj() {}

   virtual const char* GetName() const { return "Selected"; }

private:
   TGLPShapeObj(const TGLPShapeObj &); // Not implemented
   TGLPShapeObj& operator=(const TGLPShapeObj &); // Not implemented

   ClassDef(TGLPShapeObj, 0) // This object wraps TGLPhysicalShape (not a TObject)
};

#endif
