
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

/* -*- mode: C; c-basic-offset: 4  -*- */ 
#ifndef __RXP_H__
#define __RXP_H__

/* This API will undoubtedly need to be updated */

typedef struct _RXpDecoder RXpDecoder;

struct _RXpDecoder {
    /* The encoded data coming in */
    char *data;
    /* The current position of the incoming data */
    char *cur_pos;
    /* The length of the original block that you
     * are decoding */
    unsigned int original_length;
    /* The current length of the block */
    unsigned int length;
};


typedef struct _RXpEncoder RXpEncoder;

struct _RXpEncoder {
    /* The encoded data block */
    char *data;
    /* The current position in that block to which
     * to entries will be appended */
    char *cur_pos;
    /* The length of the used portion of the block */
    unsigned int length;
    /* The amount of space allocated for the block */
    unsigned int alloced;
};


/* When decoding the information, a list is returned
 * that contains each element per list item.  If the
 * item was an rbuf, the rbuf is set.  If the item
 * was a long int, buf will be NULL, and the intval
 * will be set approperiately. 
 *
 * These are allocated via rchunk_alloc, and should
 * be freed with rchunk_free(). */

typedef enum {
    RXP_TYPE_INTEGER = 1,
    RXP_TYPE_RBUF = 2,
    RXP_TYPE_NULL_RBUF = 3
} RXpEntryType;


typedef struct _RXpArrayEntry RXpArrayEntry;

struct _RXpArrayEntry {
    RXpEntryType type;
    union {
        rint32 intval;
        RBuf *buf;
    } data;
};


RXpEncoder *
rxp_encoder_new (void);

void
rxp_encode_reset (RXpEncoder *encoder);

void
rxp_encode_rint32 (RXpEncoder *encoder, rint32 value);

void
rxp_encode_rbuf (RXpEncoder *encoder, RBuf *value);

void
rxp_encoder_free (RXpEncoder *encoder);

unsigned int
rxp_decode_msg_length (char *data);

RArray *
rxp_decode_data (char *data);

#define RXP_ENCODE_RINT32(data,value) \
    (data)[0] = (value & 0xFF000000) >> 24; \
    (data)[1] = (value & 0x00FF0000) >> 16; \
    (data)[2] = (value & 0x0000FF00) >> 8; \
    (data)[3] = (value & 0x000000FF) >> 0;

#define RXP_DECODE_RINT32(data,value) \
    value = ((data)[0] & 0xFF) << 24; \
    value |= ((data)[1] & 0xFF) << 16; \
    value |= ((data)[2] & 0xFF) << 8; \
    value |= ((data)[3] & 0xFF) << 0;

#endif /* __RXP_H__ */


