/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: rsglue.c,v 1.11 2000/08/16 10:08:58 mbp Exp $
 * 
 * Copyright (C) 1999, 2000 by Martin Pool <mbp@linuxcare.com>
 * Copyright (C) 1999 by Andrew Tridgell <tridge@linuxcare.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "sysheaders.h"
#include "rproxy.h"
#include "trace.h"
#include "rsglue.h"

void
hsync_glue_log(int level, char const *msg)
{
    rp_log(LOGAREA_HSYNC, level, "%s", msg);
}


/* Return the best block size to use when generating a file signature, making 
   sure that it's no longer than RS_MAX_SIG_SIZE */
size_t choose_block_size(size_t cached_size)
{
    size_t          bs = (cached_size / (RS_MAX_SIG_SIZE / (4 + 4))) & ~15;

    if (bs < 128)
	bs = 128;
    return bs;
}
