/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *  For POSIX compliance.
 *
 *  $Id: setenv.c,v 1.6 2004/02/27 04:47:28 warnes Exp $
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "setenv.h"

int setenv(const char *name, const char *value, int clobber)
{
  char *cp;

  if (clobber == 0 && getenv(name) != 0)
    return (0);
  if ((cp = malloc(strlen(name) + strlen(value) + 2)) == 0)
    return (1);
  sprintf(cp, "%s=%s", name, value);
  return (putenv(cp));
}
