 
(define-method render-full ((self <change-request>))
  (format #t "Id:        ~d\n" (id self))
  (format #t "State:     ~a\n" (state self))
  (format #t "Title:     ~a\n" (title self))
  (format #t "Group:     ~a\n" (name (group self)))
  (if (not (null? (interest self)))
      (format #t "Interest:  ~j\n" (map name (interest self))))
  (if (not (null? (active-items self)))
      (format #t "Workers:   ~j\n" 
	      (map name (unionq (map owner (active-items self)) '()))))
  (for-each (lambda (p)
	      (if (symbol? (car p))
		  (format #t "~11a~j\n" 
			  (format #f "~C:" (car p))
			  (if (pair? (cdr p))
			      (cdr p)
			      (list (cdr p))))
		  (format #t "~11a~a\n"
			  (format #f "~C:" (name (car p)))
			  (property-value-string-form (cdr p)))))
	    (properties self))
  (format #t "\nSummary\n")
  (format #t "-------\n")
  (display (summary self))
  (newline)
  (let ((changes (select (lambda (wi)
			   (instance? wi <fs-change>))
			 (active-items self))))
    (if (pair? changes)
	(begin
	  (format #t "\nOutstanding Changes\n")
	  (format #t "-------------------\n")
	  (for-each (lambda ((fsc <fs-change>))
		      (format #t " ~a ~a:\n" 
			      (name (owner fsc))
			      (name (file-system fsc)))
		      (for-each 
		       (lambda (v)
			 (format #t "    ~6a "
				 (if (version-tag v)
				     (version-tag->string
				      (version-tag v))
				     ;; new version hasn't been checked in yet
				     "*co*"))
			 (let ((p (node->paths 
				   (file-system fsc)
				   (versioned-object v))))
			   (if (null? p)
			       (format #t "[node ~d]\n" 
				       (id (versioned-object v)))
			       (format #t "~a\n"
				       (fs-path->string (car p))))))
		       (new-versions fsc)))
		    changes))))
  (format #t "\nHistory\n")
  (format #t "-------\n")
  (for-each render-history-item (reverse (history self))))
