(define (point-in-rect? (r <rect>) (pt <point>))
  (and (>= (x pt) (origin-x r))
       (>= (y pt) (origin-y r))
       (< (x pt) (limit-x r))
       (< (y pt) (limit-y r))))

(define (rects-intersect? (r1 <rect>) (r2 <rect>))
  (let (((o <point>) (origin r2))
	((c <point>) (limit r2)))
    (or (point-in-rect? r1 o)
	(point-in-rect? r1 c)
	(point-in-rect? r1 (make-point (x o) (y c)))
	(point-in-rect? r1 (make-point (x c) (y o))))))
      

(define (coord-intersect x1 w1 x2 w2)
  (let ((m1 (+ x1 w1))
	(m2 (+ x2 w2)))
    (if (< x1 x2)
	;;
	;;  cases i, ii, iii
	;;
	(if (< m1 x2)
	    ;;
	    ;; case i
	    ;;
	    (values 0 0)
	    ;;
	    ;; cases ii, iii
	    ;;
	    (if (< m1 m2)
		;;
		;; case ii
		;;
		(values x2 (- m1 x2))
		;;
		;; case iii
		;;
		(values x2 w2)))
	;;
	;;  cases iv, v, vi
	;;
	(if (< m1 m2)
	    ;;
	    ;;  case iv
	    ;;
	    (values x1 w1)
	    ;;
	    ;;  cases v, vi
	    ;;
	    (if (< x1 m2)
		;;
		;; case v
		;;
		(values x1 (- m2 x1))
		;;
		;; case vi
		;;
		(values 0 0))))))
		
(define (intersect-rect (accum <rect>) (arg <rect>))
  (bind ((x w (coord-intersect (origin-x accum)
			       (size-width accum)
			       (origin-x arg)
			       (size-width arg)))
	 (y h (coord-intersect (origin-y accum)
			       (size-height accum)
			       (origin-y arg)
			       (size-height arg))))
    (make-rect x y w h)))

(define (union-rect (a <rect>) (b <rect>))
  (bbox-rect (min (origin-x a) (origin-x b))
	     (min (origin-y a) (origin-y b))
	     (max (limit-x a) (limit-x b))
	     (max (limit-y a) (limit-y b))))

;;;
;;;  find where two lines (A..B) and (C..D) intersect
;;;
;;;  returns #f if they do not intersect,
;;;  and three values if they do:
;;;    (1) the intersection point
;;;    (2) the handedness (one of (pl = Potentially Leaving,
;;;                                pe = Potentially Entering))
;;;    (3) the intersection parameter
;;;
;;;  [see Foley, van Dam, et.al., p.119]

(define (line-intersect (a <point>) (b <point>) (c <point>) (d <point>))
  (clip-to-segment a b c (find-perp c d a)))

(define (clip-to-segment (a <point>) (b <point>) (c <point>) (n <size>))
  (let ((den (inner-product n (point- a b)))
	(num (inner-product n (point- a c))))
    (if (= den 0)
	#f
	(let ((t (/ num den)))
	  (values
	   (point+ a (size* (point- b a) t))
	   (if (< den 0) 'pl 'pe)
	   t)))))

(define (clip-to-rect (a <point>) (b <point>) (box <rect>))
  (let ((x0 (origin-x box))
	(y0 (origin-y box))
	(x0w (limit-x box))
	(y0h (limit-y box))
	(best-pe #f)
	(best-pe-t #f)
	(best-pl #f)
	(best-pl-t #f))
    ;
    (define (submit1 p1 norm)
      (bind ((pt dir t (clip-to-segment a b p1 norm)))
	(format #t "submit ~a - ~a -> ~a ~a ~a\n" p1 norm pt dir t)
	(case dir
	  ((pe)
	   (if (or (not best-pe-t)
		   (> t best-pe-t))
	       (begin
		 (set! best-pe pt)
		 (set! best-pe-t t))))
	  ((pl)
	   (if (or (not best-pl-t)
		   (< t best-pl-t))
	       (begin
		 (set! best-pl pt)
		 (set! best-pl-t t)))))))
    ;
    (submit1 (make-point x0 y0) (make-size -1 0))
    (submit1 (make-point x0 y0h) (make-size 0 1))
    (submit1 (make-point x0w y0h) (make-size 1 0))
    (submit1 (make-point x0w y0) (make-size 0 -1))
    ;
    (values best-pe best-pl)))

;;;
;;;  find the perpendicular to a line P...R that is more toward
;;;  Q than not
;;;

(define (find-perp (p <point>) (r <point>) (q <point>))
  (let ((b (normalize (point- q p)))
	(a (normalize (point- r p))))
    (normalize (size- b (size* a (inner-product a b))))))


