
#|
(define (drawcloud frame)
  (rectstroke frame)
  ;;
  (define (pair->point p)
    (make-point (car p) (cadr p)))
  ;;
  (moveto 5.18404 4.45412)
  ;;
  (for-each
   (lambda (curv)
     (bind ((a b c (list->values curv)))
       (curveto (pair->point a)
                (pair->point b)
                (pair->point c))))
   '(((3.53404 4.40412) (0.334045 5.45412) (0.784045 7.70412))
     ((1.23404 9.95412) (3.38404 10.4541) (4.28404 9.80412))
     ((5.18404 9.15412) (2.88404 12.9541) (7.28404 13.9541))
     ((11.684 14.9541) (13.934 13.3541) (13.284 12.2041))
     ((12.634 11.0541) (17.134 14.9041) (19.234 12.7041))
     ((21.334 10.5041) (17.084 8.40412) (17.984 8.70412))
     ((18.884 9.00412) (21.634 8.60412) (20.734 4.85412))
     ((19.834 1.10412) (11.734 4.00412) (12.634 3.45412))
     ((13.534 2.90412) (11.284 0.154115) (8.48404 0.704115))
     ((5.68404 1.25412) (5.48544 2.25217) (5.18544 4.45217))))
  ;;
  (closepath)
  (stroke))

(define *cloud-points* 
  '(((3.53404 4.40412) (0.334045 5.45412) (0.784045 7.70412))
    ((1.23404 9.95412) (3.38404 10.4541) (4.28404 9.80412))
    ((5.18404 9.15412) (2.88404 12.9541) (7.28404 13.9541))
    ((11.684 14.9541) (13.934 13.3541) (13.284 12.2041))
    ((12.634 11.0541) (17.134 14.9041) (19.234 12.7041))
    ((21.334 10.5041) (17.084 8.40412) (17.984 8.70412))
    ((18.884 9.00412) (21.634 8.60412) (20.734 4.85412))
    ((19.834 1.10412) (11.734 4.00412) (12.634 3.45412))
    ((13.534 2.90412) (11.284 0.154115) (8.48404 0.704115))
    ((5.68404 1.25412) (5.48544 2.25217) (5.18544 4.45217))))

(map (lambda (l)
       (map (lambda (p)
              (list (/ (round (* 100 (/ (- (car p) 0.784045) 19.95))) 100)
                    (/ (round (* 100 (/ (- (cadr p) 0.704115) 13.25))) 100)))
            l))
     *cloud-points*)

(/ (round (* 100 (/ (- 5.18404 0.784045) 19.95))) 100)

(/ (round (* 100 (/ (- 4.45412 0.704115) 13.25))) 100)

|#

(define (drawcloud frame)
  ;;
  (define (xp x)
    (+ (origin-x frame) (* x (size-width frame))))
  (define (yp y)
    (+ (origin-y frame) (* y (size-height frame))))
  ;;
  (define (pair->point p)
    (make-point (xp (car p)) (yp (cadr p))))
  ;;
  (moveto (xp 0.22) (yp 0.28))
  ;;
  (for-each
   (lambda (curv)
     (bind ((a b c (list->values curv)))
       (curveto (pair->point a)
                (pair->point b)
                (pair->point c))))
   '(((0.14 0.28) (-0.02 0.36) (0 0.53))
     ((0.02 0.7)  (0.13 0.74)  (0.18 0.69))
     ((0.22 0.64) (0.11 0.92)  (0.33 1))
     ((0.55 1.08) (0.66 0.95)  (0.63 0.87))
     ((0.59 0.78) (0.82 1.07)  (0.92 0.91))
     ((1.03 0.74) (0.82 0.58)  (0.86 0.6))
     ((0.91 0.63) (1.05 0.6)   (1 0.31))
     ((0.95 0.03) (0.55 0.25)  (0.59 0.21))
     ((0.64 0.17) (0.53 -0.04) (0.39 0.))
     ((0.25 0.04) (0.24 0.12)  (0.22 0.28))))
  ;;
  (closepath)
  (stroke))
