/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: configapi.h
 *              
 *      Abstract: Implement getkeystring/writekeystring like Windows API 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      PaulL           22nd Jan 02     Created
 *      MarkW           9th  Feb 04     Baseline of code
 ***************************************************************************/ 


#ifndef _CONFIGAPI_H
#define _CONFIGAPI_H

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define MAX_CHARS 256          // Maximum characters/line in Configuration File.
#define NEWLINE   "\n"

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

int isfound(char *ptr, char *ini_buffer);
char *find_header(char *ini_buffer, char *header_name);
int get_parameter(char *str, int strsize, char *key, char *offset);
char *find_parameter(char *key, char *offset, int *length);
int writekeystring(char *section, char *key, char *str, char *path, char *filename);
int getkeystring(char *section, char *key, char *dest, int strsize, char *path, char *filename);

#endif //_CONFIGAPI_H
