/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: sitewepdlg.h
 *              
 *      Abstract: Implement WEP dialog for connection to WEP enabled AP 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      PaulL           22nd Jan 03     Created
 *      MarkW           9th  Feb 04     Baseline of code
 ***************************************************************************/ 


#ifndef SITEWEPDLG_H
#define SITEWEPDLG_H

#include <qvariant.h>
#include <qdialog.h>

#include "qhexvalidator.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QButtonGroup;
class QCheckBox;
class QComboBox;
class QFrame;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;

class SiteWepDlg : public QDialog
{ 
	Q_OBJECT

public:
	SiteWepDlg( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
	~SiteWepDlg();

	QFrame* Frame5;
	QButtonGroup* ButtonGroup3;
	QLabel* TextLabel10_2;
	QComboBox* WepAuthenticationComboBox;
	QButtonGroup* ButtonGroup4;
	QLabel* TextLabel11_2;
	QLabel* TextLabel12_2;
	QButtonGroup* ButtonGroup5_2;
	QRadioButton* WepKey1RadioButton;
	QRadioButton* WepKey2RadioButton;
	QRadioButton* WepKey3RadioButton;
	QRadioButton* WepKey4RadioButton;
	QLineEdit* WepKey1LineEdit;
	QLineEdit* WepKey2LineEdit;
	QLineEdit* WepKey3LineEdit;
	QLineEdit* WepKey4LineEdit;
	QComboBox* WepWEPKeyTypeComboBox;
	QComboBox* WepWEPKeyLengthComboBox;
	QCheckBox* EncryptionCheckBox;
	QPushButton* WepOkPushButton;
	QPushButton* WepCancelPushButton;

	QHexValidator  *hexValidator;	 
	bool  isWepOk;

	int	 Get_Wep_KeyID();
	int  Get_Wep_KeyLength();
	int  Get_Wep_KeyType();
	const char *Get_Wep_KeyString(int index);
	void m_ChangeAuthType(int type);   //0: open system,  1: shared key
	void m_EnableAuthType(bool bFlag);
	int  m_GetWepAuthenType();
	bool m_IsClickWepOkButton();

public slots:	
	virtual	void WepOkPushButton_Click();
	virtual	void WepCancelPushButton_Click();
	virtual	void EncryptionCheckBox_toggled(bool);
	virtual	void WepWEPKeyTypeComboBox_activated(int);
	virtual	void WepWEPKeyLengthComboBox_activated(int);
};

#endif // SITEWEPDLG_H
