/*
*  Rubrica
*  file: csv.h
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_CSV_H
#define _RUBRICA_CSV_H

#include <gnome.h>
#include "rubrica.h"

#define FIELDS 40

typedef struct _RubricaCsv {
  gchar *label; 
  gboolean import;
} RubricaCsv;


enum {
  RUBRICA_CSV_CHECK_COLUMN,         // check -> import/don't import field
  RUBRICA_CSV_FIELD_COLUMN,         // field description
  RUBRICA_CSV_DATA_COLUMN,          // data read from csv file
  RUBRICA_CSV_COLUMN
};


enum {
  RUBRICA_CSV_PREV_REC,
  RUBRICA_CSV_NEXT_REC
};

typedef enum {
  RUBRICA_CSV_NETSCAPE,
  RUBRICA_CSV_MOZILLA  
} RubricaCsvModelType;

typedef enum {
  RUBRICA_CSV_START_STATE,
  RUBRICA_CSV_QUOTE_STATE,
  RUBRICA_CSV_BUILD_BUFFER_STATE,
  RUBRICA_CSV_DOUBLE_QUOTE_STATE
} RubricaCsvParseState;


typedef enum {
  RUBRICA_CSV_MOVE_DATA_UP,
  RUBRICA_CSV_MOVE_DATA_DOWN
} RubricaCsvMoveType;



gboolean rubrica_csv_is_separator(gchar ch);
gboolean rubrica_csv_is_quote(gchar ch);

gboolean rubrica_csv_import_file(FILE *fin);
gchar *rubrica_csv_read_line(FILE *fp);
void rubrica_csv_parse_line(gchar *line);
void rubrica_csv_clean_list(void);
void rubrica_csv_insert_item(gchar *str, gint pos);
gchar *rubrica_csv_extract_item(gint n);

void rubrica_csv_add_netscape_address_to_rubrica(Rubrica *rubrica);
void rubrica_csv_add_mozilla_address_to_rubrica(Rubrica *rubrica);

GtkListStore *rubrica_csv_create_model(void);
void rubrica_csv_display_records(gint record);
void rubrica_csv_populate_model(GtkListStore *model, RubricaCsvModelType type);

GtkWidget* rubrica_csv_create_list(GtkListStore *model);
void rubrica_csv_add_column(GtkWidget *list);
GtkWidget *rubrica_csv_create_import_dialog(void);

void rubrica_csv_prev_button_click(GtkWidget *button, gpointer user_data);
void rubrica_csv_next_button_click(GtkWidget *button, gpointer user_data);
void rubrica_csv_move_data(GtkWidget *button, gpointer data);
void rubrica_csv_manage_columns(GtkCellRendererToggle *cell, gchar *path_str, 
				gpointer data);

#endif
