# Copyright 2012 Mail Bypass, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

require 'rubygems'
require 'json'
require 'date'
require 'pp'
require '../lib/messagebus_ruby_api'

# login to demo api
api_key="YOUR_ACCOUNT_API_KEY_GOES_HERE"
client= MessagebusApi::Messagebus.new(api_key)

# the unsubscribes method optionally accepts startDate and endDate parameters which define the
# range of dates on which to search for unsubscribe requests. if these parameters are not supplied, startDate
# defaults to 30 days ago and endDate defaults to today.  Format date strings as YYYY-MM-DDTHH:mm:ssZ
# or use supplied format_iso_time method
begin

  campaign_params = {:campaignName => 'MessageBus Test Campaign',
         :fromName => 'Message Bus',
         :fromEmail => 'do.not.reply@messagebus.com',
         :subject => 'This is a test campaign',
         :mailingListKey => '7215ee9c7d9dc229d2921a40e899ec5f',
         :htmlBody => "<html><body>This message is only a test sent by the Ruby Message Bus client library.</body></html>",
         :plaintextBody => 'This message is only a test sent by the Ruby Message Bus client library.',
         :tags => ['RUBY', 'Unit Test Ruby'],
         :customHeaders => {"sender"=>"apitest1@messagebus.com"}}

  status = client.campaigns_send(campaign_params)

  if status[:statusCode] == 202
    puts "Method returned successfully."
    puts "Sent and your campaign key is: #{status[:campaignKey]} at: #{status[:statusTime]} "
  else
    puts "Problem sending the campaign. #{status[:statusCode]}-#{status[:statusMessage]}"
  end
rescue Exception => e
  puts "Error occurred while sending the campaign."
  puts e.message
end