#include <rumba/manifold.h>
#include <rumba/manifoldFile.h>
#include <rumba/arghandler.h>
#include <rumba/parse.h>
#include <rumba/util.hpp>
#include <iostream>
#include <cstdlib>
#include <vector>

using std::cout;
using std::endl;
using std::cerr;
using RUMBA::stream_cast;

void error()
{
	cerr << "Usage: dumpheader [-i|--infile] infile  " << endl;
}

int main(int argc, char** argv)
{
	std::string infile;
	std::string outfile;
	std::ofstream fout;
	std::ostream* out=&std::cout;
//	RUMBA::ArgHandler::setRequiredDefaultArg("infile");
	try 
	{
		RUMBA::ArgHandler argh(argc,argv);
		if (argh.arg("help"))
		{
			error();
			return 0;
		}

		if (argh.arg("outfile"))
			argh.arg("outfile",outfile);
		argh.arg_or_loose("infile",infile);

		RUMBA::ManifoldFile* M = RUMBA::ManifoldFile::construct(infile.c_str());
		if (!M)
		{
			std::cerr << "Couldn't open input" << std::endl;
			exit(1);
		}

		if (!outfile.empty())
		{
			fout.open(outfile.c_str());
			if (!fout)
				throw RUMBA::Exception(outfile);
			out=&fout;
		}
		M->print(*out);
		delete M;

	
	}
    catch (RUMBA::MissingArgumentException& s)
    {
		cerr << "Error, missing required argument: " << s.error() << endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		cerr << "Duplicate argument: " << s.error() << endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		cerr << "Error: " << s.error() << endl;
	}                   
	catch ( RUMBA::Exception & e)
	{
		cerr << "Fatal exception " << e.error() << endl;	
	}

	return 0;
}
