#include <rumba/point.hpp>
#include <rumba/baseManifold.h>
#include <rumba/manifoldFile.h>
#include <rumba/loadVols.h>
#include <rumba/exception.h>
#include <map>
#include <algorithm>
#include <sstream>

#include <stdio.h> // remove()

using namespace std;
using namespace RUMBA;


void loadvols_report_error(const intPoint& q)
{
	std::cerr << 
		q.x() <<" " << q.y() << " " <<  q.z() << " " << q.t() << std::endl;
}

namespace 
{
	bool check (const intPoint& q, const intPoint& upper, const intPoint& lower
			= intPoint())
	{
		return 
			q.x() >= lower.x() && q.x() < upper.x()  && 
			q.y() >= lower.y() && q.y() < upper.y() && 
		   	q.z() >= lower.z() && q.z() < upper.z() && 
			q.t() >= lower.t() && q.t() < upper.t();	
	}



	intPoint getDims(ManifoldFile* M)
	{
		intPoint dims;
		dims = M->extent();
		return dims;
	}

	doublePoint getOrigin(ManifoldFile* M)
	{
		doublePoint o;
		M->headerData()["OriginX"].asDouble(o.x());
		M->headerData()["OriginY"].asDouble(o.y());
		M->headerData()["OriginZ"].asDouble(o.z());
		return o;
	}

	doublePoint getVoxelSize(ManifoldFile* M)
	{
		doublePoint o;
		M->headerData()["dimX"].asDouble(o.x());
		M->headerData()["dimY"].asDouble(o.y());
		M->headerData()["dimZ"].asDouble(o.z());
		M->headerData()["dimT"].asDouble(o.t());
		return o;
	}



	int nDims_function(intPoint p)
	{
		int i = 4;
		if (p.t() <= 1 )
			i--;
		else
			return i;

		if (p.z() <= 1 )
			i--;
		else 
			return i;

		if (p.y() <= 1 )
			i--;
		else
			return i;

		if (p.x() <= 1 )
			i--;

		return i;
	}

	bool check_dims(const std::vector<RUMBA::intPoint>& v)
	{
		for ( std::vector<RUMBA::intPoint>::const_iterator it = v.begin();
				it!=v.end();++it )
			if (*it != v[0])
				return false;
		return true;
	}

	std::string getDimString(int i,const std::string& s)
	{
		switch(i)
		{
			case 0:
				return s + "X";
			case 1:
				return s + "Y";
			case 2:
				return s + "Z";
			case 3: 
				return s + "T";
			default:
				throw 
					RUMBA::Exception("Argument out of range in getDimString()");
		}
	}

}




bool RUMBA::fileNumberComparison(string s,string t)
{
	return getFileNumber(s) < getFileNumber(t);
}

int RUMBA::getFileNumber ( string s )
{
	int i=0;
	string t = s;
	t.assign ( t,0, t.find_last_of (".") );	
	t.assign ( t,  t.find_last_not_of ( "0123456789" ) + 1, t.length() );
	std::istringstream stream ( t );
	stream >> i;
	return i;
}

void RUMBA::doNothing(vector<string>&) {}

void RUMBA::sortFilesByOrigin(vector<string>& filenames)
{
	map<doublePoint, string> origin;
	ManifoldFile* f;

	// get information.
	for (vector<string>::const_iterator it = filenames.begin(); 
			it != filenames.end(); ++it )
	{
		f = ManifoldFile::construct(it->c_str());
		if (!f)
			throw RUMBA::BadFile(*it);

		origin.insert ( make_pair( getOrigin(f), *it ) );
		delete f;
	}

	filenames.clear();

	for ( map<doublePoint, string>::iterator it = origin.begin();
	   it != origin.end(); ++it )
	{
		filenames.push_back(it->second);
	}
}


void RUMBA::sortFilesByName(vector<string>& filenames)
{
	sort(filenames.begin(), filenames.end() );
}

void RUMBA::sortFilesByNumber(vector<string>& filenames)
{
	sort(filenames.begin(),filenames.end(),fileNumberComparison);
}

// bool operator==(const RUMBA::Point<int>&, RUMBA::Point<int>&){ return 1; }

void RUMBA::loadVols
(
 	vector<string>& filenames, 
	string outfile, 
	void (*sortfunction) (vector<string>&)
)
{
	if (filenames.empty()) return;
	vector<RUMBA::intPoint> dimensions;
	int nDim;
	ManifoldFile* f;
//	BaseManifold* M;
	ManifoldFile* outManifold;
	intPoint p;

	RUMBA::Orientation in_orient;
	RUMBA::Orientation out_orient;
	bool is_orient_set = false;
	RUMBA::PointTransform t;
   
	out_orient = RUMBA::Orientation 
		( 
		 RUMBA::patient_right(), RUMBA::patient_back(), 
		 RUMBA::patient_foot(), RUMBA::intPoint(), 1
		 );


	// get information.
	for (vector<string>::const_iterator it = filenames.begin(); 
			it != filenames.end(); ++it )
	{
		f = ManifoldFile::construct(it->c_str());
		if (!f)
			throw RUMBA::BadFile(*it);

		if (!is_orient_set)
		{
			in_orient = f->orientation();
			RUMBA::intPoint tmp = in_orient.extent();
			if (tmp.z() < 2)
				in_orient.setExtent(intPoint(tmp.x(),tmp.y(),filenames.size(),1));
			else
				in_orient.setExtent(intPoint(tmp.x(),tmp.y(),tmp.z(),filenames.size()));
			t =  RUMBA::transform(in_orient, out_orient);
			is_orient_set = true;
		}

		dimensions.push_back ( getDims(f) );
		delete f;
	}


	// check dimensions
	if (!check_dims(dimensions))
		throw RUMBA::Exception("Incompatible dimensions");

	// How many dimensions are the data sets ?
	nDim = nDims_function(dimensions[0]);

	if (nDim <2 || nDim >3 )
		throw RUMBA::Exception("Wrong number of dimensions");

	sortfunction ( filenames );

	// now open and load!

	f = ManifoldFile::construct(filenames[0]);
	if (!f)
	{
		throw RUMBA::BadFile(std::string("Could not open file ")+filenames[0]);
	}

	p = f->extent();
	if ( nDim == 2 )
		p.z() = filenames.size();
	if ( nDim == 3 )
		p.t() = filenames.size();


	p = t.map_extent(p);


	//----- WARNING: ad-hoc code
	intPoint permutation_point (0,1,2,3);
	permutation_point = t.map_extent(permutation_point);
	std::cerr << permutation_point << std::endl;
	doublePoint new_voxelsize;
	new_voxelsize[0] = f->voxelSize()[permutation_point[0]];
	new_voxelsize[1] = f->voxelSize()[permutation_point[1]];
	new_voxelsize[2] = f->voxelSize()[permutation_point[2]];
	new_voxelsize[3] = f->voxelSize()[permutation_point[3]];
	if (nDim == 2)
		new_voxelsize[3] *= filenames.size();
	std::cerr << new_voxelsize << std::endl;

	RUMBA::BaseManifold* proto = f->get(0,0,0,0,1,1,1,1);
	proto->setExtent(p);
	proto->setVoxelSize(new_voxelsize);

	/*
	outManifold->setVoxelSize(getVoxelSize(f));
	std::cerr << new_voxelsize << std::endl;
	outManifold->setVoxelSize(new_voxelsize);
	outManifold->headerData()["dimX"] = outManifold->voxelSize().x();
	outManifold->save();
	*/
	//-----------------------------


/*
	outManifold = ManifoldFile::construct 
		( 
		 outfile, 
		 f->headerData()["normalized_datatype"].asString(), p 
		 );
*/
	outManifold = ManifoldFile::construct 
		( 
		 outfile, std::ios::out, proto
		);
	delete proto;
	if (!outManifold)
	{
		delete f;
		throw RUMBA::BadFile(std::string("Could not open file ")+outfile);
	}

	outManifold->setCacheStrategy(RUMBA::CACHE_VOL);


	delete f;

	int i = 0;
	for (vector<string>::const_iterator it = filenames.begin();
			it != filenames.end();
			++it, ++i
			)
	{
		f = ManifoldFile::construct( it->c_str() );
		if (!f)
		{
			delete outManifold;
			remove (outfile.c_str());
			throw RUMBA::BadFile (
				std::string("Couldn't open file for writing: ") + *it 
			);
		}
		f->setCacheStrategy(RUMBA::CACHE_VOL);
//		M=f->get(intPoint(0,0,0,0), intPoint(f->width(),f->height(),f->depth(),1));
//		delete f;


		loadvols_report_error(outManifold->extent());
		if ( nDim == 2 )
		{
//			outManifold->put ( M, intPoint(0,0,i,0));
			RUMBA::intPoint p(0,0,i,0),q(0,0,0,0);
//			t = RUMBA::transform( f->orientation(), out_orient);
			for (p.x() = 0;  p.x() < f->width(); ++p.x() )
				for ( p.y() = 0; p.y() < f->height(); ++p.y() )
				{
					// we need to set p.z() = i when we do the transform, so 
					// that the slice is placed at the right offset in 
					// outManifold. However, p.z() needs to be 0 since we use
					// it to read a 2d slice.
					p.z()=i; t(p,q); p.z()=0;
//						q = t.map_extent(p);
//					q.z() = i;
					if (! check(q,outManifold->extent()))
					{
						t.debug();
						loadvols_report_error(p);
						loadvols_report_error(q);

					}
					outManifold->setElementDouble
						( q, f->getElementDouble (p) );
					/*
					std::cerr << "----" << std::endl;
					loadvols_report_error(p);
					loadvols_report_error(q);
					std::cerr << "----" << std::endl;
					*/

				}



		}
		else if ( nDim == 3 )
		{
//			outManifold->put (	M, intPoint(0,0,0,i));
			RUMBA::volume_transform(*f, 0, *outManifold, i  );


		}
		else 
		{
			throw RUMBA::Exception("Internal error in loadVols(), nDims has invalid value\n");
		}
		delete f;
	}

}




