// #include <iohandler.h>

#include <rumba/rumbafactory.h>
#include <CommonFile.h>
#include <string>
#include <fstream>
// #include <analyze_header_request.h>
#include <rumba/binary_header.h>
#include <rumba/rumba_system.h>
#include <rumba/exception.h>
#include <rumba/parse.h>
#include <rumba/parsecsv.h>

#include <sys/stat.h>

using RUMBA::CommonFile;
using RUMBA::ManifoldFile;
using RUMBA::header_request;

using std::endl;
using std::list;
using std::map;
using std::string;


// specific hack to determine byte order.
// if the header_request includes LittleEndian, leave the 
// body of this function empty
void CommonFile::endian_hack(const char* filename, ifstream& in)
{
}


CommonFile::CommonFile()
	: data_extension(""), header_extension(""), classname("CommonFile")
{
	loadRc();
}

CommonFile::CommonFile( Exemplar a )
:ManifoldFile(a), data_extension(""), header_extension(""), classname("CommonFile")
{
	log.logName() << "loading rc ... ";
	loadRc(); // important !! we use this in isMine()
	log.logName() << "done ";

	log.logName() << "Calling " << classname << "(Exemplar)\n";
}

bool CommonFile::isMine( std::string filename )
{
	log.logName() << "Calling " << classname << "::isMine(" << filename << ")\n";
	string ext;
	ext.assign( filename, filename.find_last_of("."), filename.length()); 
	return( ext == data_extension || ext == header_extension );
}


ManifoldFile* 
CommonFile::make( std::string filename, int mode, const BaseManifold* manifoldPtr)
{
	log.logName() << "Entering " << classname << "::make( " << filename << " " << mode << ") " << endl;
	log.logName() << "header extension: " << header_extension << endl;
	CommonFile* res = new CommonFile;
	// get header file
	std::string basename;

	basename.assign (filename, 0, filename.find_last_of("."));
	res->HeaderFile = basename + header_extension;
	res->DataFile = basename + data_extension;

	if ( mode & ios::in )
		res->loadHeader(res->HeaderFile.c_str());
	else if (manifoldPtr)
	{
		res->copyHeader ( *manifoldPtr );
		res->saveHeader(res->HeaderFile.c_str());
	}
	else
	{
		// throw an appropriate exception.
		;	
	}


	// Should move this elsewhere.
	res->initFile (mode);
	log.logName() << "Leaving " << classname << "::make() " << endl;
	return res;
}

// initialise Data
void CommonFile::initFile(int mode)
{
	log.logName() << "Calling initFile()" << endl;
	Factory* f;	

	if ( HeaderData.count("datatype") )
		f = getFactoryFromDataType ( HeaderData["datatype"].asString() );
	else
		f = getFactoryFromDataType  ( types["defaulttype"] );

	if (f) {
		Data = f->makeIOHandler ( DataFile.c_str(), mode);
	}

	// else throw an exception !
	log.logName() << "Leaving initFile()" << endl;
}




void CommonFile::saveHeader(const char* filename) 
{
	log.logName() << "Calling " << classname << "::saveHeader(" << filename << ")\n";

	std::ofstream fin(filename);

	if (!fin){
		debug( "Manifold: cannot open file " );
		#ifdef USE_EXCEPTIONS
		throw RUMBA::BadFile ( "loadHeader : Cannot open file");
		#endif
	}

	fin.seekp( stream_cast<int>(header_size)  - 1 );
	fin.put(0);

	loadCsv();
	copyHeaderDataFromManifold();

	fillRequiredHeaders();
	RUMBA::putData ( HeaderData, HeaderRequests, fin, LittleEndian );
	fin.close();


}



void CommonFile::loadHeader(const char* filename)
{	
	log.logName() << "Calling " << classname << "::loadHeader(" << filename << ")\n";

	std::ifstream fin(filename);

	if (!fin){
		debug( "Manifold: cannot open file " );
		#ifdef USE_EXCEPTIONS
		throw RUMBA::BadFile ( "loadHeader : Cannot open file");
		#endif
	}

	endian_hack(filename,fin);

	loadCsv();
	log.logName() << "calling GetData()" << endl;
	HeaderData = RUMBA::getData ( HeaderRequests, fin, LittleEndian );
	log.logName() << "succesfully got out of getData()" << endl;

	for ( std::map<std::string, RUMBA::Splodge>::const_iterator it = HeaderData.begin(); it!=HeaderData.end(); ++it)
	{
		log.logName() << "HeaderData : " << it->first << " " << it->second << endl;
	}
	fin.close();
	log.logName() << "succesfully got out of getData()" << endl;
	copyHeaderDataToManifold();

}

void CommonFile::loadCsv()
{
	std::ifstream conf_in;

	std::string basename = classname + std::string(".csv");
	std::string conf = RUMBA::find_file_modules() + string("/") + basename; 

	conf_in.open(conf.c_str());
	if ( !conf_in )
	{
		log.logName() << "Couldn't open file: " << conf << endl;
		throw RUMBA::BadFile(conf);
	}
	parseCsv(HeaderRequests, conf_in);
	cout << "Succesfully loaded csv file" << endl;
}

void CommonFile::loadRc()
{
	std::ifstream conf_in;

	std::string basename = classname + std::string(".rc");
	std::string conf = RUMBA::find_file_modules() + string("/") + basename; 
	log.logName() << "Opening rc file: " << conf << endl;

	conf_in.open(conf.c_str());
	if ( !conf_in )
	{
		log.logName() << "Couldn't open file: " << conf << endl;
		throw RUMBA::BadFile(conf);
	}
	
	RUMBA::rcFind(conf_in, "data extension", data_extension );
	RUMBA::rcFind(conf_in, "header extension", header_extension );
	RUMBA::rcFind(conf_in, "header size", header_size );
	



	types["char"] = "";
	types["int16"] = "";
	types["int32"] = "";
	types["float32"] = "";
	types["float64"] = "";
	types["defaulttype"] = "";

	RUMBA::rcFind(conf_in, "char", types["char"] );
	RUMBA::rcFind(conf_in, "int16", types["int16"] );
	RUMBA::rcFind(conf_in, "int32", types["int32"] );
	RUMBA::rcFind(conf_in, "float32", types["float32"] );
	RUMBA::rcFind(conf_in, "float64", types["float64"] );
	RUMBA::rcFind(conf_in, "defaulttype", types["defaulttype"] );

}

void CommonFile::copyHeaderDataToManifold()
{
	/*------- Should check return values and possibly throw exceptions. 
	  Note that nothing should go wrong here if this code is consistent 
	  with csv specification -----------------*/

	HeaderData["width"].asInt(Width);
	HeaderData["height"].asInt(Height);
	HeaderData["depth"].asInt(Depth);
	HeaderData["timepoints"].asInt(TimePoints);
	HeaderData["dimX"].asFloat(DimX);
	HeaderData["dimY"].asFloat(DimY);
	HeaderData["dimZ"].asFloat(DimZ);
}

void CommonFile::copyHeaderDataFromManifold()
{
	HeaderData["width"]=Width;
	HeaderData["height"]=Height;
	HeaderData["depth"]=Depth;
	HeaderData["timepoints"]=TimePoints;
	HeaderData["dimX"]=DimX;
	HeaderData["dimY"]=DimY;
	HeaderData["dimZ"]=DimZ;
}

RUMBA::Factory* CommonFile::getFactoryFromDataType(std::string t)
{
	log.logName() << "In getFactoryFromDataType() : t is " << t << endl;
	log.logName() << "types[float64] " << types["float64"] << endl;
	if ( t == types["char"] || t == "char" )
		return CharFactory::get();
	else if ( t == types["int16"] || t == "int16" )
		return ShortFactory::get();
	else if ( t == types["int32"] || t == "int32" )
		return IntFactory::get();
	else if ( t == types["float32"] || t == "float32" )
		return FloatFactory::get();
	else if ( t == types["float64"] || t == "float64" )
		return DoubleFactory::get();

	throw RUMBA::Exception("getFactoryFromDataType failed");
}

void CommonFile::fillRequiredHeaders()
{
	list<header_request>::const_iterator lit;
	map<string, RUMBA::Splodge >::const_iterator mit;

	if ( HeaderRequests.empty() ) 
	{
		return;
	}

	for (lit = HeaderRequests.begin(); lit != HeaderRequests.end(); ++lit )
		if ( lit->required )
		{
			mit = HeaderData.find(lit->name);
			if ( mit == HeaderData.end() )
			{
				HeaderData.insert ( std::make_pair( lit->name, lit->default_value ));
				log.logName() << "Adding required header " << lit->name << "=" << lit->default_value << endl;
			}
			else if ( mit->second.asString() == "0" || mit->second.asString() == "" )
			{
				HeaderData[ lit->name ] =  lit->default_value;
				log.logName() << "Adding required header " << lit->name << "=" << lit->default_value << endl;
			}
		}
}
