#include <map>
#include <string>
#include <splodge.h>
#include <fstream>
#include <fileIO.h>
#include <constants.h>
#include <header_request.h>
#include <iostream>
#include <siemens_header_request.h>
#include <analyze_header_request.h>
#include <maxmin.hpp>


#include <cmath>
#include <sys/stat.h>
#include <transforms.h>

/**
 * @authors = Donovan Rebbechi, Ben Bly
 * DO NOT DISTRIBUTE WITHOUT PERMISSION -- THIS IS FRAGILE CODE!
 * IT IS FOR INTERNAL USE ONLY.
 */

#define INENDIAN 0 //0 = big-endian, 1=little-endian
#define OUTENDIAN 1 //0 = big-endian, 1=little-endian

int getTopLeft(int image, int width, int height, int depth, int sliceOrder);
int getTopRight(int image, int width, int height, int depth, int sliceOrder);
int getBottomLeft(int image, int width, int height, int depth, int sliceOrder);
int getBottomRight(int image, int width, int height, int depth, int sliceOrder);

std::map<std::string, RUMBA::Splodge>



char find_orientation(char top, char back)
{
	if ( (top == 'A'  || top == 'P') && ( back == 'H' || back == 'F' ) )
		return '0';
	if ( (top == 'H'  || top == 'F') && ( back == 'A' || back == 'P' ) )
		return '1';
	if ( (top == 'H'  || top == 'F') && ( back == 'L' || back == 'R' ) )
		return '2';
	return '0';
}




int curpos ( int topLeft, int x, int y, int width )
{
	return topLeft + x + (width*y); 
}


MaxMinFunctor<short> writeAnalyzeData (ifstream& in, ofstream& out, int width, int height, int depth, int nTilesWide,int sliceOrder)
{
	int imageTopLeft;
	MaxMinFunctor<short> f;
	for (int image=0;image<depth;image++)
	{
		imageTopLeft = getTopLeft (image,width,height,depth,sliceOrder);
		for (int y = 0; y<height; y++)
			for (int x = 0; x<width; x++) {
				// need to multiply flatToMosaic() by 2 data are two bytes wide
				in.seekg( 2 * 
						flatToMosaic
						(width,height,depth,nTilesWide, 
						 curpos (imageTopLeft,x,y,width ) )
						+ SIEMENS_HEADER_SIZE
						);
				short val = GetShort(in,INENDIAN);
				f(val); // register the value with the functor.
				PutShort ( out,val,OUTENDIAN );
			}
	}
	return(f);
}

int getTopLeft (int image, int width, int height, int depth, int sliceOrder)
{
	int imageSize = width * height;
	switch (sliceOrder)
	{
		case 1: // ascending
			return ( ( image ) * imageSize );
			break; 
		case 2: // descending
			return ( ( depth - (image + 1) ) * imageSize );	
			break;
		case 4: // interleaved
			return ( ( image%2 * depth/2 + image/2 ) * imageSize );
			break;
		default:
			cerr << "warning: sliceOrder not recognised" << endl;
	}
}


int getTopRight (int image, int width, int height, int depth, int sliceOrder)
{
	int imageSize = width * height;
	switch (sliceOrder)
	{
		case 1: // ascending
			return ( ( image ) * imageSize + width );
			break; 
		case 2: // descending
			return ( ( depth - (image + 1) ) * imageSize + width );	
			break;
		case 4: // interleaved
			return ( ( image%2 * depth/2 + image/2 ) * imageSize + width );
			break;
		default:
			cerr << "warning: sliceOrder not recognised" << endl;
	}
}

int getBottomLeft (int image, int width, int height, int depth, int sliceOrder)
{
	int imageSize = width * height;
	switch (sliceOrder)
	{
		case 1: // ascending
			return (((image+1) * imageSize)- width);
			break; 
		case 2: // descending
			return ((depth - image) * imageSize - width);	
			break;
		case 4: // interleaved
			return (( image%2 * depth/2 + image/2 + 1 ) * imageSize - width);
			break;
		default:
			cerr << "warning: sliceOrder not recognised" << endl;
	}
}

int getBottomRight (int image, int width, int height, int depth, int sliceOrder)
{
	int imageSize = width * height;
	switch (sliceOrder)
	{
		case 1: // ascending
			return ( ( image + 1 ) * imageSize - 1 );
			break; 
		case 2: // descending
			return ( ( depth - image ) * imageSize - 1 );	
			break;
		case 4: // interleaved
			return ( ( image%2 * depth/2 + image/2 + 1 ) * imageSize - 1 );
			break;
		default:
			cerr << "warning: sliceOrder not recognised" << endl;
	}
}

int ima2analyze_main(int argc, char** argv)
{
	int width,height,depth,tiles;
	int fileSize;
	struct stat fileStat;
	int top;

	if ( argc < 4 )
	{
		cerr << "You must provide an output header and data file\n";
		exit(1);
	}
	//cout << argv[1] << endl;

	ifstream in (argv[1]);

	std::map<std::string, RUMBA::Splodge> data;

	data = getData(siemens_header_request,in,INENDIAN);

	std::map<std::string, RUMBA::Splodge>::const_iterator it;

#ifdef DEBUG
	for ( it = data.begin(); it != data.end(); ++it )
	{
		cout << it->first << " " << it->second << endl;
	}
#endif

	int displayMatrixSize;
	if ( ! data["private_DisplayMatrixSize"].asInt( displayMatrixSize ) )
		cerr << "Help! DisplayMatrixSize isn't an int\n";

	width = displayMatrixSize;
	height = displayMatrixSize;
	// 2 is the size of the data type short in the ima data
	stat(argv[1], &fileStat );

	tiles = ( fileStat.st_size - SIEMENS_HEADER_SIZE ) / ( width * height * 2 );	
	ofstream headerOut( argv[2] );
	ofstream dataOut( argv[3] )	;
	
	// massage to analyze

	data["width"] = width;
	data["height"] = height;

	if ( ! data["private_NumSlices"].asInt( depth ) )
		cerr << "Help! numSlices isn't an int\n";
	//cout << "depth = "<<depth << endl;
	//cout << "tiles = "<<tiles << endl;
	if ( tiles == 1 ) depth = 1;
	
	data["depth"] = depth;
	data["timepoints"] = 1;
	data["headerSize"] = 348;	
	data["nDims"] = 4;

	double fovX, fovY;
    if ( data["FOVX"].asDouble( fovX ) )
		data["dimX"] = fovX/width;
    if ( data["FOVY"].asDouble( fovY ) )
		data["dimY"] = fovY/width;
	
	double tmp_dbl;
	if  ( data["dimZ"].asDouble ( tmp_dbl ) ) 
		        data["dimZ"] = tmp_dbl;
	if  ( data["dimT"].asDouble ( tmp_dbl ) ) 
		        data["dimT"] = tmp_dbl/1000.0;

	//cout<<"dims x,y,z,t = "<<data["dimX"]<<" "<<data["dimY"]<<" "<<data["dimZ"]<<" "<<data["dimT"]<<endl;
	data["datatype"] = TYPE_SHORT;
	// From http://www.mayo.edu/bir/Analyze_Pages/AnalyzeFileInfo.html
	// these are required:
	data["hkey_regular"] = std::string("r");
	data["hkey_extents"] = 16384;
	data["sizeof(datatype)"] = 16; // bits per pixel
	
	if ( ! data.count("hist_sMin") )
		data["hist_sMin"] = 0;

	int sliceOrder = 1;
	if ( ! data["private_SliceOrder"].asInt( sliceOrder ) )
		cerr << "Slice Order assumed to be ascending"<<endl;
	//cout<<"sliceOrder = " << sliceOrder << endl;

	MaxMinFunctor<short> f = writeAnalyzeData(in, dataOut, width,height,depth, (int)(std::sqrt(tiles)),sliceOrder);


	data["calibrationMax"] = 0.0;
	data["calibrationMin"] = 0.0;
	data["max"] = (int) f.max();
    data["min"] = (int) f.min();

	char orientation;
	if (
			data.count("private_OrientationSet1Top") && 
			data.count("private_OrientationSet1Left") &&
			data.count("private_OrientationSet1Back") 
		)
	{
	orientation = find_orientation(
				data["private_OrientationSet1Top"].asString()[0], 
				data["private_OrientationSet1Back"].asString()[0]
				);
	}
	else
	{
		data["hist_orient"] = std::string("0");
	}
	data["hist_orient"] = std::string() +  orientation ;

			
	cout<<"Orientation = " << orientation << endl;

	putData( data, analyze_header_request, headerOut );

	return 0;
}


