#ifndef RUMBA_STIMULATE_FILE_H
#define RUMBA_STIMULATE_FILE_H

#include <rumba/exemplar.h>
#include <rumba/manifoldFile.h>
#include <string>



namespace RUMBA
{
class StimulateFile : public ManifoldFile 
{

public:
	StimulateFile();
	StimulateFile(Exemplar);
	virtual bool isMine(std::string s);
	void saveHeader(const char* filename);
	void loadHeader(const char* filename);
	ManifoldFile* getNew();

	void initFile (std::ios_base::openmode mode);
	void loadRc();

private:

	RUMBA::Factory* getFactoryFromDataType(std::string);
	std::string normalizeDataType(std::string);


	int DisplayRange[2];


};
	extern StimulateFile StimulateFileInstance;
	extern StimulateFile* StimulateFileExemplar;

}

#endif
