#include <rumba/arghandler.h>
#include <rumba/util.hpp>
#include <string>
#include <iostream>



void usage()
{
	std::cerr << 
		"Usage: histogram -i infile -o outfile\n"
		"[-u|--upper n1  -l|--lower n2] [--bins bins]\n";
}


RUMBA::Argument myArgs [] = {
	RUMBA::Argument("lower", RUMBA::NUMERIC, 'l'),
	RUMBA::Argument("upper", RUMBA::NUMERIC, 'u'),
	RUMBA::Argument("bins", RUMBA::NUMERIC, 'n' ),
	RUMBA::Argument()
};


int main(int argc,char** argv)
{
	std::string infile , outfile;
	double lower=0,upper=0;
	int n = 0;
	std::vector<int> v;
	RUMBA::ManifoldFile* fin = 0;
	try {
		RUMBA::ArgHandler argh ( argc , argv, myArgs );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}
		argh.arg ( "infile" , infile );

		/* either both or neither of the lower and upper bounds must be given */
		if (argh.arg("lower") ^ argh.arg("upper"))
		{
			throw RUMBA::ArgHandlerException ("--lower must be accompanied by --upper, and vice-versa\n");
		}

		if (argh.arg("bins"))
			argh.arg("bins",n);
		else
			n=10;

		fin = RUMBA::ManifoldFile::construct(infile.c_str());
		if (!fin)
			throw RUMBA::Exception("Fatal: couldn't open file for input");
		fin->setCacheStrategy(RUMBA::CACHE_VOL);

		if (argh.arg("lower"))
		{
			argh.arg("lower",lower);
			argh.arg("upper",upper);
			v = RUMBA::histogram( n, fin, lower, upper );
		}
		else
		{
			v = RUMBA::histogram( n, fin, &lower, &upper );
		}


		for ( std::vector<int>::size_type i = 0; i < v.size(); ++i )
			std::cout << ((upper-lower) * i)/n + lower 
				<< " " << v[i] << std::endl;

	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
		exit(1);
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
		exit(1);
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
		exit(1);
	}
	catch (RUMBA::Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
		exit(1);
	}
}
