#!/usr/bin/perl -w
use strict;

use vars qw/$infile $outfile $outfile2 $infile2/;

sub error
{
	die "Usage: input.pl -i infile -o outfile\n";
}

sub extension
{
	my $arg = shift;
	$arg =~ s/.*\./\./;
	return $arg;
}

sub extensiontable
{
	my $ext = shift;
	if ( $ext eq ".img" ) { return ".hdr"; }
	if ( $ext eq ".hdr" ) { return ".img"; }

	if ( $ext eq ".spr" ) { return ".sdt"; }
	if ( $ext eq ".sdt" ) { return ".spr"; }

	return "";
}

sub getother
{
	my $arg = shift;
	my $ext = extension($arg);
	my $newext = extensiontable($ext);
	if ( $newext eq "" )
	{
		return "";
	}

	$arg=~s/$ext$//;
	$arg=$arg.$newext;
	return $arg;
}

if ( $#ARGV != 3 )
{
	&error();
}




while ($#ARGV >=0)
{

	if ( $ARGV[0]  eq "-i" )
	{
		$infile = $ARGV[1];
		shift @ARGV;
		shift @ARGV;
	}
	elsif ( $ARGV[0] eq "-o" )
	{
		$outfile = $ARGV[1];
		shift @ARGV;
		shift @ARGV;
	}
	else
	{
		&error();
	}
}

if ( extension ( $infile ) ne extension ( $outfile ) )
{
	die "Incompatible file types\n";
}

-e $infile ||  die "input file does not exist"; 


symlink $infile, $outfile;

$outfile2 = getother ( $outfile );
$infile2 = getother ( $infile );

if ( $infile2 ne "" )
{
	symlink $infile2, $outfile2;
}

exit(0);

