#include <rumba/baseManifold.h>
#include <rumba/exception.h>
#include "normalize.h"
#include "stats.h"

namespace 
{
void get_shift_and_scale 
( const RUMBA::StatFunctor& f, int type, double& shift, double& scale);
}


namespace RUMBA
{
	const int MEAN_NORMALIZE = 1;
	const int Z_NORMALIZE = 2;
	const int RANGE_NORMALIZE = 4;
}


namespace 
{
void get_shift_and_scale 
( const RUMBA::StatFunctor& f, int type, double& shift, double& scale)
{
	if ( type == RUMBA::RANGE_NORMALIZE )
	{
		scale = f.max() - f.min();
		shift = f.min();
	}
	else if ( type == RUMBA::Z_NORMALIZE )
	{
		shift = f.mean();
		scale = f.sd();
	}
	else if ( type == RUMBA::MEAN_NORMALIZE )
	{
		shift = f.mean();
		scale = 1;
	}
	else
	{
		throw RUMBA::Exception ("Invalid normalize type in get_shift_and_scale()"); 
	}
}
}

void RUMBA::global_normalize(RUMBA::BaseManifold* pM, int type)
{
	RUMBA::BaseManifold& M = *pM;
	RUMBA::StatFunctor f(pM);
	
	double shift=0,scale=1;

	get_shift_and_scale(f,type,shift,scale);

	if (scale != 0 )
	{
		for ( int i = 0; i < M.size(); ++i )
			M[i] = ((double)M[i] - shift) / scale;
	}
	else
	{
		for ( int i = 0; i < M.size(); ++i )
			M[i] = 0;
	}

}

void RUMBA::volume_normalize(RUMBA::BaseManifold* pM, int type)
{
	RUMBA::BaseManifold& M = *pM;

	double shift =0, scale=1;
	intPoint ext = M.extent();
	ext.t()=1;
	for ( int i = 0; i < M.timepoints(); ++i )
	{
		RUMBA::StatFunctor f(pM, intPoint(0,0,0,i), ext);
		get_shift_and_scale(f,type,shift,scale);
	
		if (scale != 0 )
		{
			for ( int j = 0; j < M.pixels(); ++j )
				M[i*M.pixels()+j] = ( (double)M[i*M.pixels()+j] - shift)/scale;
		}
		else
		{
			for ( int j = 0; j < M.pixels(); ++j )
				M[i*M.pixels()+j] = 0;
		}
	}
}

void RUMBA::pixel_normalize(RUMBA::BaseManifold* pM, int type)
{
	RUMBA::BaseManifold& M = *pM;
	double shift =0, scale=1;
	int x,y,z;
	for ( int i = 0; i < M.pixels(); ++i )
	{
		x = i % M.width();
		y = (i / M.width()) % M.height();
		z = (i / (M.width()*M.height()) ) % M.depth();

		RUMBA::StatFunctor 
			f(pM, intPoint(x,y,z,0), intPoint(1,1,1,M.timepoints()));
		get_shift_and_scale(f,type,shift,scale);
	
		if (scale != 0 )
		{
			for ( int j = 0; j < M.timepoints(); ++j )
				M[i+j*M.pixels()] = ((double)M[i+j*M.pixels()] - shift )/scale;
		}
		else
		{
			for ( int j = 0; j < M.timepoints(); ++j )
				M[i+j*M.pixels()] = 0;
		}
	}
}

