#include <iostream>

#include "../matrixutils/t_dist.h"
#include <rumba/matrixio.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/arghandler.h>
#include <rumba/manifoldFile.h>



using RUMBA::Argument;
using RUMBA::ManifoldMatrix;
using RUMBA::Manifold;
using RUMBA::ManifoldFile;
using RUMBA::BaseManifold;
using RUMBA::t_to_p;

void usage()
{
	std::cerr << "Usage: t2p-transform (--infile|-i) infile (--outfile|-o) "
		"outfile --df df" << std::endl;
}

RUMBA::Argument myArgs[] = 
{
	RUMBA::Argument("df", RUMBA::NUMERIC, '\0', 1 ),
	RUMBA::Argument()
};

int main(int argc, char** argv)
{

	std::string infile, outfile, bigmatrix, singular;
	double df;	
	try 
	{
		RUMBA::ArgHandler argh(argc,argv,myArgs);		
		if ( argh.arg( "help") )
		{
			usage();
			return 0;
		}
		argh.arg( "infile", infile );
		argh.arg( "outfile", outfile );
		argh.arg( "df", df );
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl; exit(1);
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl; exit(1);
	}
	catch (RUMBA::MissingArgumentException& s)
	{
		std::cerr << "Missing argument: " << s.error() << std::endl; exit(1);
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl; exit(1);
	}
	catch (RUMBA::Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl; exit(1);
	}

	ManifoldFile* fin = ManifoldFile::construct(infile.c_str());
	ManifoldFile* fout = ManifoldFile::construct 
		( outfile.c_str(), "float64", fin->extent() );;
	BaseManifold* M;
	RUMBA::intPoint e = fin->extent();
	e.t() = 1;
	int px = fin->pixels();
	int top;
	Manifold<double> out (e);
	
	for ( int i =0; i < fin->timepoints(); ++i)
	{
		M = fin->get(RUMBA::intPoint(0,0,0,i), e);
		
		top = (i+1)*px;	
		for ( int j = i*px, k = 0; j < top; ++j, ++k )	
			out.setElementDouble ( k, 100*t_to_p(M->getElementDouble(j),df ) );

		fout->put(&out, RUMBA::intPoint(0,0,0,i));
		
		delete M;

	}



}
