// rumbaview brainview.h

#ifndef BRAINVIEW_H
#define BRAINVIEW_H

#include <utility>
#include <qframe.h>
#include <qpainter.h>
#include <qpopupmenu.h>
#include <qtimer.h>

#include <rumba/manifold.h>
#include "colorbar.h"
#include "colormap.h"

/**
  *@author Giorgio Grasso, Ben Bly, Donovan Rebbechi
  */

#define MAX_CMAP	25

enum View { AXIAL=0, SAGITAL, CORONAL };

class BrainView : public QFrame  {
	Q_OBJECT
public:
	typedef std::pair<double,double> dPoint;
	BrainView(QWidget *parent=0,View v=AXIAL, 
		const char *name="",float zoom=1.0,bool stretch=false, 
		bool mainview = false, dPoint scale = dPoint(0,1));
	~BrainView();
	void setManifold(RUMBA::Manifold<short> *vol);
	void setUnderlay(RUMBA::Manifold<short> *vol);
	void initColormap();


signals:
	void cursorMoved(int x, int y, int z);
	void windowMoved(int wx, int wy);
	void changeThreshold(int t, int T);
	void recompose(QRect out, QRect in);
	/*
	void greyCmap();
	void hotmetalCmap();
	void jetCmap();
	*/

	void Cmap(int id);


public slots:
	void slotCursorMoved(int x, int y, int z);
	void slotCursorMoved(int t);
	void slotWindowMoved(int dx, int dy);
	void slotRecompose(QRect out, QRect in);
	void slotChangeThreshold(int t, int T);
	/*
	void slotGreyCmap();
	void slotHotmetalCmap();
	void slotJetCmap();
	*/

// slot used from outside -- uses color number in color list, and _not_ menu id.
	void slotSetCmapExternal(int index); 


private slots:
	void slotSetCmap(int id);

	void save();
	void saveAll();
	void recompose();
	void resetAll();
	void resetAspect();
	void resetSize();
	void resetBrightness();
	void resetContrast();
	void changeCrossHair();
	void changeCoordinates();
	void changeAnimate();
	void updateAnimate();
	void changeThreshold();
	void quit();

protected:
	virtual void mousePressEvent(QMouseEvent *qme);
	virtual void mouseReleaseEvent(QMouseEvent *qme);
	virtual void mouseMoveEvent(QMouseEvent *qme);
	virtual void resizeEvent(QResizeEvent *qre);
	virtual void moveEvent(QMoveEvent *qme);
	virtual void paintEvent(QPaintEvent *qpe);
	virtual void keyPressEvent(QKeyEvent *qke);

private:
	void showImage();
	void updateImage();
	void showCursor();
	void updateCursor(int x, int y);
	void getSlice(int slice);
	void clearCmapMenu();
	void setGamma(float g);
	void setContrast(float c);
	int adjust(int col);
	void resetAspect( bool fixwidth );

	RUMBA::Manifold<short> *volume, *underlay_volume;
	char caption[256];
	QPopupMenu *menu, *cmap_menu, *reset_menu;
	int id_crosshair, id_coordinates, id_animate, id_threshold;
	int id_grey, id_hotmetal, id_jet;
	int n_cmap, *id_cmap; // , id_cmap[MAX_CMAP];
	//QSlider *tslider;
	ColorBar *tslider;
	QTimer *animate_timer;
	int thresh_min, thresh_max;
	QImage *image, *underlay_image;
	QPainter *painter;
	QCursor curs;
	View view;
	int cx, cy, cz, ct;
	bool underlay, crosshair, mainview, coordinates, threshold;
	bool shown, animate;
	bool stretch;
	float mag_x, mag_y, magnification;
	float gamma, contrast;
	int mx, my;
	float mc, mg;
	RUMBA::Colormap *colormap, *underlay_colormap;
	long grey_cmap[256], hotmetal_cmap[256], jet_cmap[256];
	dPoint Scale;
};

#endif
