/*
 * $Id: logging.h,v 1.9 2001/02/26 07:06:28 gcw Exp $
 */

#ifndef _LOGGING_H_
#define _LOGGING_H_

#ifdef UTMP_SUPPORT
# if ! defined(HAVE_STRUCT_UTMPX) && ! defined(HAVE_STRUCT_UTMP)
#  error cannot build with utmp support - no utmp or utmpx struct found
# endif

# ifdef RXVT_UTMP_AS_UTMPX
#  define RXVT_REAL_UTMP_FILE	RXVT_UTMPX_FILE
# else
#  define RXVT_REAL_UTMP_FILE	RXVT_UTMP_FILE
# endif

# ifdef HAVE_LASTLOG_H
#  include <lastlog.h>
# endif
# include <pwd.h>

# ifdef USE_SYSV_UTMP
#  ifndef USER_PROCESS
#   define USER_PROCESS		7
#  endif
#  ifndef DEAD_PROCESS
#   define DEAD_PROCESS		8
#  endif
#  ifdef RXVT_UTMP_AS_UTMPX
#   define setutent		setutxent
#   define getutent		getutxent
#   define getutid		getutxid
#   define endutent		endutxent
#   define pututline		pututxline
#  endif
# endif

# ifdef WTMP_SUPPORT
#  ifdef RXVT_UTMP_AS_UTMPX
#   define update_wtmp		updwtmpx
#   ifdef RXVT_WTMPX_FILE
#    define RXVT_REAL_WTMP_FILE	RXVT_WTMPX_FILE
#   else
#    error cannot build with wtmp support - no wtmpx file found
#   endif
#  else
#   define update_wtmp		rxvt_update_wtmp
#   ifdef RXVT_WTMP_FILE
#    define RXVT_REAL_WTMP_FILE	RXVT_WTMP_FILE
#   else
#    error cannot build with wtmp support - no wtmp file found
#   endif
#  endif
# endif

# ifdef __QNX__
#  include <sys/utsname.h>
#  undef USE_SYSV_UTMP
#  define ut_name		ut_user
# endif

#include "logging.intpro"		/* PROTOS for internal routines */
#endif
#endif /* _LOGGING_H_ */
