/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This source file is part of SableVM.                            *
 *                                                                 *
 * See the file "LICENSE" for the copyright information and for    *
 * the terms and conditions for copying, distribution and          *
 * modification of this source file.                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SVM_FATAL_H
#define SVM_FATAL_H

/* The __func__ is only defined in C99, so we can't rely on it being defined.
   The __FUNCTION__ OTOH is a non-standard define available in older GCC. */
#ifdef __func__
#  define _svmm_fatal_error(msg) \
     _svmh_fatal_error(__FILE__, __func__, __LINE__, msg)
#else
#  ifdef __FUNCTION__
#    define _svmm_fatal_error(msg) \
       _svmh_fatal_error(__FILE__, __FUNCTION__, __LINE__, msg)
#  else
#    define _svmm_fatal_error(msg) \
       _svmh_fatal_error(__FILE__, "unknown", __LINE__, msg)
#  endif
#endif

#endif /* not SVM_FATAL_H */
