/*
 * $Id: widget_focus.c 2464 2010-01-09 03:11:36Z vapour $
 *
 * Salasaga: Functions used to track the internal delete focus, for when the delete key is pressed
 *
 * Copyright (C) 2005-2010 Justin Clift <justin@salasaga.org>
 *
 * This file is part of Salasaga.
 *
 * Salasaga is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 *
 */


// GTK includes
#include <gtk/gtk.h>

#ifdef _WIN32
	// Windows only code
	#include <windows.h>
#endif

// Salasaga includes
#include "../salasaga_types.h"
#include "../externs.h"


// Variables common to these functions
static gint				focus = FOCUS_UNKNOWN;


// Returns the presently set delete focus
gint get_delete_focus(void)
{
	return focus;
}

// Sets the present delete focus
void set_delete_focus(gint focus_to_set)
{
	focus = focus_to_set;
}
