/*
 * SunOS doesn't provide a memmove() function, and you cannot simply put
 * -Dmemmove=memcpy in the Makefiles because memcpy() doesn't support
 * overlapping copies. Oddly enough, bcopy() does! So we can write memmove
 * as a wrapper around bcopy.
 *
 * If you don't have bcopy(), or if it doesn't support overlapping copies,
 * you can still define NO_BCOPY and use the generic version below.
 * It's very slow of course, as it copies only one byte at a time.
 * Complain to your vendor, or get a real Unix.
 */

#ifdef NO_BCOPY
char *memmove (char *dest, char *src, unsigned long count)
{
	char *save_dest = dest;

	if (dest < src) {
		while (count--)
			*dest++ = *src++;
	} else {
		src  += count;
		dest += count;
		while (count--)
			*--dest = *--src;
	}
	return save_dest;
}
#else
char *memmove (char *dest, char *src, unsigned long count)
{
	bcopy(src, dest, count);
	return dest;
}
#endif
