#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc PolygonDialog {frame id} {
    global marker

    # see if we already have a header window visible

    set w ".marker$id"
    set mb ".mb$id"

    if [winfo exist $w] {
	raise $w
	return
    }

    # Init common items

    InitMarkerDialog $frame $id
    PropMenuPolygonDialog $frame $mb $id
    CoordMenuMarkerDialog $frame $mb $id CoordPolygonCB
    CoordMarkerCB $frame $id

    # file menu items

    $mb.file add command -label "Apply" \
	-command "ApplyPolygonDialog $frame $id"
    $mb.file add separator
    $mb.file add command -label "Close" \
	-command "ClosePolygonDialog $frame $id"

    # Init polygon variables

    EditPolygonCB $frame $id
    RotateMarkerCB $frame $id

    # polygon specific callbacks

    $frame marker $id callback edit EditPolygonCB $frame
    $frame marker $id callback rotate RotateMarkerCB $frame
    $frame marker $id callback delete DeletePolygonDialog $frame

    # Dialog

    CommonMarkerDialog $frame $id
    wm protocol $w WM_DELETE_WINDOW "ClosePolygonDialog $frame $id"

    label $w.ref.f.angleTitle -text "Angle"
    entry $w.ref.f.angle -textvariable marker($frame,$id,angle) -width 13
    label $w.ref.f.angleUnit -relief groove -width 9 -padx 4 \
	-text "degrees"

    grid $w.ref.f.angleTitle $w.ref.f.angle x $w.ref.f.angleUnit \
	-padx 4 -sticky w

    # Buttons

    button $w.buttons.apply -text "Apply" \
	-command "ApplyPolygonDialog $frame $id"
    button $w.buttons.close -text "Close" \
	-command "ClosePolygonDialog $frame $id"
    pack $w.buttons.apply $w.buttons.close -side left -padx 10 -expand true

    bind $w <Return> "ApplyPolygonDialog $frame $id"

    # some window managers need a hint
    raise $w
}

proc ApplyPolygonDialog {frame id} {
    EditPolygonDialog $frame $id
    RotateMarkerDialog $frame $id
    ApplyMarkerDialog $frame $id
}

proc ClosePolygonDialog {frame id} {
    global marker

    $frame marker $id delete callback edit EditPolygonCB
    $frame marker $id delete callback rotate RotateMarkerCB
    $frame marker $id delete callback delete DeletePolygonDialog
    DeleteMarkerCBs $frame $id

    DeletePolygonDialog $frame $id
}

proc DeletePolygonDialog {frame id} {
    global marker

    DeleteMarkerDialog $frame $id

    unset marker($frame,$id,angle)
}

proc EditPolygonDialog {frame id} {
}

proc EditPolygonCB {frame id} {
}

proc CoordPolygonCB {frame id} {
    CoordMarkerCB $frame $id

    MoveMarkerCB $frame $id
    RotateMarkerCB $frame $id
}

proc PropMenuPolygonDialog {frame mb id} {
    global menu
    global marker

    menu $mb.properties -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.properties add checkbutton -label "Can Edit" \
	-variable marker($frame,$id,edit) \
	-command "PropertyMarkerDialog $frame $id edit"
    $mb.properties add checkbutton -label "Can Move" \
	-variable marker($frame,$id,move) \
	-command "PropertyMarkerDialog $frame $id move"
    $mb.properties add checkbutton -label "Can Rotate" \
	-variable marker($frame,$id,rotate) \
	-command "PropertyMarkerDialog $frame $id rotate"
    $mb.properties add checkbutton -label "Can Delete" \
	-variable marker($frame,$id,delete) \
	-command "PropertyMarkerDialog $frame $id delete"
    $mb.properties add separator
    $mb.properties add radiobutton -label Include \
	-variable marker($frame,$id,include) -value 1 \
	-command "PropertyMarkerDialog $frame $id include"
    $mb.properties add radiobutton -label Exclude \
	-variable marker($frame,$id,include) -value 0 \
	-command "PropertyMarkerDialog $frame $id include"
    $mb.properties add separator
    $mb.properties add radiobutton -label Source \
	-variable marker($frame,$id,source) -value 1 \
	-command "PropertyMarkerDialog $frame $id source"
    $mb.properties add radiobutton -label Background \
	-variable marker($frame,$id,source) -value 0 \
	-command "PropertyMarkerDialog $frame $id source"
}

proc PolygonDefaultDialog {} {
    global marker
    global ed

    set w ".polygon"

    set ed(ok) 0
    set ed(width) $marker(polygon,width)
    set ed(height) $marker(polygon,height)

    DialogCreate $w "Default Polygon" -borderwidth 2
    frame $w.ed  -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ed $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.ed.title -text "Width"
    entry $w.ed.width -textvariable ed(width) -width 10 
    label $w.ed.unit -text "image" -relief groove -width 8
    
    label $w.ed.title2 -text "Height"
    entry $w.ed.height -textvariable ed(height) -width 10 
    label $w.ed.unit2 -text "image" -relief groove -width 8

    grid $w.ed.title $w.ed.width $w.ed.unit -padx 4  -pady 1 -sticky w
    grid $w.ed.title2 $w.ed.height $w.ed.unit2 -padx 4  -pady 1 -sticky w

    button $w.buttons.ok -text "OK" -default active -command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    $w.ed.width select range 0 end
    DialogWait $w ed(ok) $w.ed.width
    DialogDismiss $w

    if {$ed(ok)} {
	set marker(polygon,width) $ed(width)
	set marker(polygon,height) $ed(height)
    }

    unset ed
}
