// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __ellipseannulus_h__
#define __ellipseannulus_h__

#include "baseellipse.h"

class EllipseAnnulus : public BaseEllipse {
private:
  void updateHandles();
  void sortRadii();

public:
  EllipseAnnulus(const EllipseAnnulus&);
  EllipseAnnulus(FrameBase* p, const Vector& ctr, const Vector& r, double a, 
		 const char* clr,  int w, const char* f, 
		 const char* t, unsigned short prop, const char* c,
		 const List<Tag>& tag);

  EllipseAnnulus(FrameBase* p, const Vector& ctr, 
		 const Vector& inner, const Vector& outer, int, double a, 
		 const char* clr,  int w, const char* f, 
		 const char* t, unsigned short prop, const char* c,
		 const List<Tag>& tag);

  EllipseAnnulus(FrameBase* p, const Vector& ctr, double a, int an, Vector* r,
		 const char* clr,  int w, const char* f,
		 const char* t, unsigned short prop, const char* c,
		 const List<Tag>& tag);

  Marker* dup() {return new EllipseAnnulus(*this);}
  void edit(const Vector&, int);
  void editEnd();

  const Vector* getRadii() {return radii;}
  void setRadii(const Vector&, const Vector&, int);
  void setRadii(const Vector*, int);
  int addRadii(const Vector&);
  void deleteRadii(int h);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOimage(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
};

#endif


