#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc ARCancel {varname} {
    upvar #0 $varname var
    global $varname

    if {[info exists var(token)]} {
	set var(state) 0
	http::reset $var(token)
    }
}

proc ARDestroy {varname} {
    upvar #0 $varname var
    global $varname

    if {[info exists var(token)]} {
	set var(state) 0
	http::reset $var(token)
    }

    if {[winfo exists $var(top)]} {
	destroy $var(top)
	destroy $var(mb)
    }

    catch {
	unset var(xname)
	unset var(yname)
	unset var(cancel)
	unset var(apply)

	unset var(status)
	unset var(current)
	unset var(sync)

	unset var(proc,next)
    }
}

proc ARReset {varname} {
    upvar #0 $varname var
    global $varname

    set var(state) 0

    catch {unset var(token)}

    $var(mb).file entryconfig Retrieve -state normal
    $var(mb).file entryconfig Cancel -state disabled

    $var(apply) configure -state normal
    $var(cancel) configure -state disabled
}

proc ARError {varname code} {
    upvar #0 $varname var
    global $varname

    ARStatus $varname "Error code $code was returned"
    ARReset $varname
}

proc ARStatus {varname message} {
    upvar #0 $varname var
    global $varname

    set var(status) "Status: $message"
}

proc ARClear {varname} {
    upvar #0 $varname var
    global $varname

    set var(name) {}
    set var(x) {}
    set var(y) {}

    ARStatus $varname {}
}

proc ARCoord {varname} {
    upvar #0 $varname var
    global $varname

    switch -- $var(sky) {
	fk4 -
	fk5 -
	icrs {
	    $var(xname) configure -text "a" -font {symbol 12}
	    $var(yname) configure -text "d" -font {symbol 12}
	}
	galactic {
	    $var(xname) configure -text "l" -font {-family times -slant italic}
	    $var(yname) configure -text "b" -font {-family times -slant italic}
	}
	ecliptic {
	    $var(xname) configure -text "l" -font {symbol 12}
	    $var(yname) configure -text "b" -font {symbol 12}
	}
    }
}

proc AREditMenu {varname} {
    upvar #0 $varname var
    global $varname

    global menu

    $var(mb) add cascade -label Edit -menu $var(mb).edit
    menu $var(mb).edit -tearoff 0 -selectcolor $menu(selectcolor)
    $var(mb).edit add command -label Cut -state disabled
    $var(mb).edit add command -label Copy -state disabled
    $var(mb).edit add command -label Paste -state disabled
    $var(mb).edit add command -label Clear -command "ARClear $varname"
}
