#! /bin/sh

if [ "$2" = "val" ]; then
#    CMD="valgrind --leak-check=yes --show-reachable=yes ../ds9val"
    CMD="valgrind --leak-check=yes ../ds9val"
    XPA=ds9val
else
    CMD=../ds9
    XPA=ds9
fi

echo "Print Tests"

echo "Starting DS9..."
if [ `xpaaccess $XPA` = no ]; then
    $CMD&

    i=1
    while [ "$i" -le 30 ]
	do
	sleep 2
	if [ `xpaaccess $XPA` = yes ]; then
	    break
	fi

	i=`expr $i + 1`
    done
fi

doit() {
    echo $1
    xpaset -p $XPA print palette $2
    xpaset -p $XPA print level $3
    xpaset -p $XPA print
}

xpaset -p $XPA scale zscale
xpaset -p $XPA print command '{gv -}'
xpaset -p $XPA grid
#xpaset -p $XPA contour

if [ "$1" = "single" -o  -z "$1" ]; then
echo "Testing Single"

xpaset -p $XPA file img16.fits
xpaset -p $XPA regions load ds9.fk5.hms.reg

doit "..RGB Level 2" rgb 2
doit "..CMYK Level 2" cmyk 2
doit "..Gray Level 2" gray 2

doit "..RGB Level 1" rgb 1
doit "..Gray Level 1" gray 1

echo "PASSED"
fi

if [ "$1" = "mosaicfast" -o  -z "$1" ]; then
echo "Testing Mosaic Fast"

xpaset -p $XPA file mosaicimageiraf mosaicimage.fits
xpaset -p $XPA regions load ds9.mosaic.fk5.hms.reg

doit "..RGB Level 2" rgb 2
doit "..CMYK Level 2" cmyk 2
doit "..Gray Level 2" gray 2

doit "..RGB Level 1" rgb 1
doit "..Gray Level 1" gray 1

echo "PASSED"
fi

if [ "$1" = "mosaicslow" -o  -z "$1" ]; then
echo "Testing Mosaic Slow"

xpaset -p $XPA prefs mosaicfast no
xpaset -p $XPA file mosaicimageiraf mosaicimage.fits
xpaset -p $XPA regions load ds9.mosaic.fk5.hms.reg

doit "..RGB Level 2" rgb 2
doit "..CMYK Level 2" cmyk 2
doit "..Gray Level 2" gray 2

doit "..RGB Level 1" rgb 1
doit "..Gray Level 1" gray 1

xpaset -p $XPA prefs mosaicfast yes

echo "PASSED"
fi

if [ "$1" = "rgb" -o  -z "$1" ]; then
echo "Testing RGB"

xpaset -p $XPA rgb
xpaset -p $XPA file rgbcube rgbcube.fits

doit "..RGB Level 2" rgb 2
doit "..CMYK Level 2" cmyk 2
doit "..Gray Level 2" gray 2

doit "..RGB Level 1" rgb 1
doit "..Gray Level 1" gray 1

echo "PASSED"
fi

echo "DONE"

if [ -z "$1" ]; then
xpaset -p $XPA quit
fi

