#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

# support

proc MarkerAnalysisPlot2dDialog {varname} {
    upvar #0 $varname var
    global $varname
    global marker

    set id $var(id)
    set frame $var(frame)

    # plot already?
    # set var(plot2d) $marker(plot2d)
    set vvarname proj${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname
    set var(plot2d) [APPing $vvarname]

    # init
    set var(pcoord) $var(system)
    set var(psky) $var(sky)
    set var(method) [$var(frame) get marker $var(id) analysis param]

    $var(mb).analysis add checkbutton -label [msgcat::mc {Plot 2D}] \
	-variable ${varname}(plot2d) \
	-command "MarkerAnalysisPlot2dCmd $varname"
    $var(mb).analysis add separator
    $var(mb).analysis add cascade -label [msgcat::mc {Method}] \
	-menu $var(mb).analysis.method
    $var(mb).analysis add cascade -label [msgcat::mc {Coordinate}] \
	-menu $var(mb).analysis.coord

    menu $var(mb).analysis.method
    $var(mb).analysis.method add radiobutton -label [msgcat::mc {Average}] \
	-variable ${varname}(method) -value average \
	-command "MarkerAnalysisPlot2dMethod $varname"
    $var(mb).analysis.method add radiobutton -label [msgcat::mc {Sum}] \
	-variable ${varname}(method) -value sum \
	-command "MarkerAnalysisPlot2dMethod $varname"

    CoordMenu $var(mb).analysis.coord $varname pcoord 1 psky {} \
	[list MarkerAnalysisPlot2dSystem $varname]
    CoordMenuEnable $var(mb).analysis.coord $varname pcoord 1 psky {}
}

proc MarkerAnalysisPlot2dCmd {varname} {
    upvar #0 $varname var
    global $varname

    MarkerAnalysisPlot2d $var(frame) $var(id) $var(plot2d)
}

proc MarkerAnalysisPlot2d {frame id plot} {
    $frame marker $id analysis plot2d $plot
    if {$plot} {
	MarkerAnalysisPlot2dCB $frame $id

	set vvarname proj${id}${frame}
	upvar #0 $vvarname vvar
	global $vvarname

	APRaise $vvarname
    } else {
	MarkerAnalysisPlot2dDeleteCB $frame $id
    }
}

proc MarkerAnalysisPlot2dMethod {varname} {
    upvar #0 $varname var
    global $varname

    $var(frame) marker $var(id) analysis param $var(method)
    if {$var(plot2d)} {
	MarkerAnalysisPlot2dCB $var(frame) $var(id)
    }
}

proc MarkerAnalysisPlot2dSystem {varname} {
    upvar #0 $varname var
    global $varname

    $var(frame) marker $var(id) analysis system $var(pcoord) $var(psky)
    if {$var(plot2d)} {
	MarkerAnalysisPlot2dCB $var(frame) $var(id)
	MarkerAnalysisPlot2dXAxisTitle $var(frame) $var(id)
    }
}

# hardcoded marker.C
proc MarkerAnalysisPlot2dCB {frame id} {
    set varname proj${id}${frame}
    upvar #0 $varname var
    global $varname

    set xx proj${id}${frame}x
    set yy proj${id}${frame}y
    set xe proj${id}${frame}xe
    set ye proj${id}${frame}ye

    set xc proj${id}${frame}xc
    set yc proj${id}${frame}yc

    global $xx $yy $xe $ye $xc $yc
    if {[APPing $varname]} {
	$frame get marker $id analysis plot2d $xx $yy $xc $yc 
	APStats $varname
    } else {
	global ed
	set rr [$frame get wcs]
	set ed(pcoord) [lindex $rr 0]
	set ed(psky) [lindex $rr 1]
	AdjustCoordSystem ed pcoord

	set tt [string totitle [$frame get marker $id type]]
	APDialog $varname $tt $tt $ed(pcoord) Counts
	# setup our own formatting
	set var(format) 0
	$var(graph) xaxis configure \
	    -command "MarkerAnalysisPlot2dXAxis $frame $id"

	set var(xdata) $xx
	set var(ydata) $yy
	set var(xedata) $xe
	set var(yedata) $ye

	blt::vector create $xx $yy $xe $ye $xc $yc
	$frame marker $id analysis system $ed(pcoord) $ed(psky)
	$frame get marker $id analysis plot2d $xx $yy $xc $yc

	APExternal $varname
	MarkerAnalysisPlot2dXAxisTitle $frame $id
    }
}

proc MarkerAnalysisPlot2dDeleteCB {frame id} {
    set varname proj${id}${frame}
    upvar #0 $varname var
    global $varname

    set xc proj${id}${frame}xc
    set yc proj${id}${frame}yc

    global $xc $yc
    catch {blt::vector destroy $xc $yc}
    # clear any errors
    global errorInfo
    set errorInfo {}

    APDestroy $varname
}

proc MarkerAnalysisPlot2dXAxisTitle {frame id} {
    set varname proj${id}${frame}
    upvar #0 $varname var
    global $varname

    set ss [$frame get marker $id analysis system]
    set system [lindex $ss 0]
    set sky  [lindex $ss 1]
    switch -- $system {
	image -
	physical -
	amplifier -
	detector {set title "$system"}
	default {
	    if {[$frame has wcs equatorial $system]} {
		set title "$sky"
	    } else {
		set title "[$frame get wcs name $system]"
	    }
	}
    }
    $var(graph) xaxis configure -title $title
}

proc MarkerAnalysisPlot2dXAxis {frame id w xx} {
    set varname proj${id}${frame}
    upvar #0 $varname var
    global $varname

    set x [expr $xx-1]
    set xc proj${id}${frame}xc
    set yc proj${id}${frame}yc

    global $xc $yc
    # sometimes, $x equals $xc length
    set ll [$xc length]
    if {($ll>=1) && ($x>=0) && ($x<$ll)} {
	set a [format "%6.3f" [expr "$$xc\($x\)"]]
	set b [format "%6.3f" [expr "$$yc\($x\)"]]
	return "$a\n$b"
    } else {
	return {}
    }
}
