
#ifndef IIRBASE_COMMENT_HH
#define IIRBASE_COMMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_Comment.hh,v 1.2 1999/03/09 20:49:02 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR.hh"

class IIR_Comment;

class IIRBase_Comment : public IIR {

public:
  IIR_Kind get_kind() {return IIR_COMMENT;}
  IIR_Char *get_kind_text() {return "IIR_Comment";}

  static IIR_Comment *get( IIR_Char *text, IIR_Int32 text_length);
  IIR_Char *get_text();
  IIR_Int32 get_text_length();

  void set_element( IIR_Int32 subscript, IIR_Char value);
  IIR_Char operator[]( IIR_Int32 subscript );

  void set_text( IIR_Char *txt, IIR_Int32 text_len);

  void release();

protected:
  IIRBase_Comment();
  virtual ~IIRBase_Comment() = 0;
    
private:
  IIR_Char *text;
  IIR_Int32 text_length;

  void _check_bounds( IIR_Int32 );

};
#endif
