// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConcatenationOperator.cc,v 1.2 1999/03/09 20:53:30 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_ConcatenationOperator.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "symbol_table.hh"

IIRScram_ConcatenationOperator::~IIRScram_ConcatenationOperator() {}

void 
IIRScram_ConcatenationOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " & ";
}

void 
IIRScram_ConcatenationOperator::_publish_cc() {
  _cc_out << "(const ";
  get_subtype()->_publish_cc_type_name();
  _cc_out << " ) ";
  // Check and see if we need to explicitly build a new subtype. If so do it
  if (get_subtype() != get_subtype()->_get_bottom_base_type()) {
    get_subtype()->_publish_cc_type_name();
    _cc_out << "(ObjectBase::VARIABLE";
    get_subtype()->_publish_cc_constructor_args();
    _cc_out << ", ";
  }
  
  _publish_cc_operator_name();
  _cc_out << "(";
  
  get_left_operand()->_publish_cc();
  _cc_out << ", ";
  get_right_operand()->_publish_cc();

  if (get_left_operand()->_get_subtype()->_get_bottom_base_type() ==
      get_right_operand()->_get_subtype()->_get_bottom_base_type()) {
    if (get_left_operand()->_get_subtype()->_get_bottom_base_type() ==
	get_subtype()->_get_element_subtype()->_get_bottom_base_type()) {
      _cc_out << ",(";
      get_subtype()->_publish_cc_type_name();
      _cc_out << " *)NULL";
    }
  }
  _cc_out << ")";

  if (get_subtype() != get_subtype()->_get_bottom_base_type()) {
    _cc_out << ")";
  }
}

// Why is this bounds set to NULL?
// It is easier to detect the bounds of the argument at run time than at
// compile time.  Example:
//   x := y & "laskdjf" & 'c' & z;
void 
IIRScram_ConcatenationOperator::_publish_cc_bounds() {
  _cc_out << "nullInfo";
}
void 
IIRScram_ConcatenationOperator::_publish_cc_operator_name() {
  _cc_out << "savantConcatenate";
}

IIR*
IIRScram_ConcatenationOperator::_clone() {
  IIR_ConcatenationOperator *clone = new IIR_ConcatenationOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_ConcatenationOperator::_get_operator_precedence(){
  return IIRScram::ADDING_OPERATOR;
}
