// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConstantDeclaration.cc,v 1.2 1999/03/09 20:53:48 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_ConstantDeclaration.hh"
#include "IIR_Attribute.hh"
#include "IIR_ConcurrentGenerateForStatement.hh"
#include "IIR_Label.hh"
#include "IIR_ProcessStatement.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "symbol_table.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_ConstantDeclaration::~IIRScram_ConstantDeclaration() {}


void 
IIRScram_ConstantDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << " constant ";
  IIRScram_ObjectDeclaration::_publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_subtype_indication_with_expression(_vhdl_out);
}

void 
IIRScram_ConstantDeclaration::_publish_vhdl_range( ostream &_vhdl_out ) {
  get_subtype()->_publish_vhdl_range( _vhdl_out );
}


// In case the constant is declared within a package, it should be static to
// that class.  We can do this by looking at the "kind" of the
// _current_publish_node.
void 
IIRScram_ConstantDeclaration::_publish_cc_decl() {
  switch(get_subtype()->get_kind()) {
  case IIR_ARRAY_TYPE_DEFINITION :
  case IIR_ARRAY_SUBTYPE_DEFINITION:
  case IIR_RECORD_TYPE_DEFINITION:
    get_subtype()->_publish_cc();
    _cc_out << " ";
    _publish_cc();
    _cc_out << ";" << endl;
    break;
  case IIR_ACCESS_TYPE_DEFINITION:
  case IIR_ACCESS_SUBTYPE_DEFINITION:
    //This will be called eventually
    //get_subtype()->_publish_cc();
    _cc_out << "  AccessVariable<char*> ";
    // _cc_out <<  " " << *get_declarator();
    _cc_out << " ";
    _publish_cc();
    _cc_out << ";" << endl;
    break;
  case IIR_FILE_TYPE_DEFINITION:
    get_subtype()->_publish_cc();
    break;
  default:
    _cc_out << "  ";
    if (get_subtype()->_is_scalar_type() == TRUE) {
      get_subtype()->_publish_cc_kernel_type();
    }
    else {
      get_subtype()->_publish_cc_type_name();
    }
    // _cc_out <<  " " << *get_declarator() << ";" << endl;
    _cc_out << " ";
    _publish_cc();
    _cc_out << ";" << endl;
    break;
  }
}  


void 
IIRScram_ConstantDeclaration::_publish_cc_elaborate() {
  if (_is_implicit_declaration() == TRUE) {
    _get_declarator()->_publish_cc();
  }
  else {
    // This ASSERT is not entirely correct but is in place to catch
    // probable errors.
    ASSERT(get_value() != NULL);
    get_value()->_publish_cc_value();
  }
}


void
IIRScram_ConstantDeclaration::_set_scoping_prefix() {
  strstream prefix;
  IIR_Char* prefix_string = NULL;
  IIR_ProcessStatement* process_ptr = _get_current_process_statement();
  
  if (process_ptr == NULL) {
    return;
  }

  if((_get_currently_publishing_unit() != IIRScram::PROCEDURE) &&
     (_get_currently_publishing_unit() != IIRScram::FUNCTION) &&
     (_get_currently_publishing_unit() != PROCESS)) {
    _set_publish_prefix_string(NULL);
    return;
  }
  
  if ((_get_currently_publishing_unit() == PROCESS) &&
      (_get_declarative_region() == _get_current_process_statement())) {
    _set_publish_prefix_string(NULL);
    return;
  }
  
  switch (_get_declarative_region()->get_kind()) {
  case IIR_BLOCK_STATEMENT:
  case IIR_ENTITY_DECLARATION:
  case IIR_ARCHITECTURE_DECLARATION:
  case IIR_CONCURRENT_GENERATE_IF_STATEMENT:
    if (_get_currently_publishing_unit() == PROCESS) {
      prefix << "((";
      process_ptr->_get_enclosing_scope()->_publish_cc_binding_name(prefix);
      prefix << "_elab *) proc)->";
    }
    else {
      prefix << "((";
      process_ptr->_get_label()->_print(prefix);
      prefix << " *) processPtr)->";
    }
    
    process_ptr->_publish_cc_scoping_prefix(_get_declarative_region(),
					    process_ptr, prefix);
    break;
    
  case IIR_PROCESS_STATEMENT:
    prefix << "((";
    process_ptr->_get_label()->_print(prefix);
    prefix << " *) processPtr)->";
    break;

  case IIR_FOR_LOOP_STATEMENT:
    if (_is_currently_publishing_subprogram() == TRUE) {
      break;
    }
    
  case IIR_CONCURRENT_GENERATE_FOR_STATEMENT:
    prefix << "((";
    process_ptr->_get_label()->_print(prefix);
    prefix << "_state *) ";
    
    if (_get_currently_publishing_unit() != PROCESS) {
      prefix << "((";
      process_ptr->_get_label()->_print(prefix);
      prefix << " *) ";
      prefix << " processPtr)->";
    }

    prefix << "state->current)->";
    
  case IIR_PACKAGE_DECLARATION:
    // Available globally.
    break;
    
  default:
    cerr << "Error - IIRScram_ConstantDeclaration::_set_scoping_prefix() :"
	 << " unhandled case.\n";
  }
  
  prefix << ends;
  prefix_string = prefix.str();
  _set_publish_prefix_string(prefix_string);
}


void 
IIRScram_ConstantDeclaration::_publish_cc() {
  // Here, we mangle the constant's declarator with it's pointer (string),
  // to make it unique.  This is not required in all the cases, however,
  // we have to mangle the iterator in a for loop statement since we could
  // have two for loops with the same declarator.

  _set_scoping_prefix();

  if ((_get_declarative_region()->get_kind() != IIR_ENTITY_DECLARATION) &&
      (_get_declarative_region()->get_kind() != IIR_PACKAGE_DECLARATION)) {
    IIRScram::_publish_cc_prefix_string();
  }
  
  if(_get_currently_publishing_unit() == IIRScram::TYPE) {
    get_value()->_publish_cc();
  } else if(_get_currently_publishing_unit() == IIRScram::PACKAGE) {
    _get_declarator()->_publish_cc();
  } else {
    //     _publish_cc_declarative_region(); // Must be uncommented eventually
    _get_declarator()->_publish_cc();
  }

  if(_is_implicit_declaration() == TRUE) {
    _cc_out << "Addr" << this;
  }

  // The constant declaration has to be added to the cgen symbol table
  // after the constants in it's value part have been added.  This makes
  // sure that during C++ publishing, the values used to initialize this
  // constant are added before this.
  // WARNING: Temporary fix: Should not reach here if implicit declaration.
  if(get_value() != NULL) {
    // This condition is blowing up when we publish initialization value in
    // the architecture before we start publishing the processes. This should
    // be removed later,
    if ( cgen_sym_tab_ptr != NULL){
      get_value()->_add_decl_into_cgen_symbol_table();
    }
  }

  // cgen_sum_tab_ptr may be NULL during elaboration, such as when the
  // index constraint contains a const. decl.
  if (cgen_sym_tab_ptr != NULL && (!cgen_sym_tab_ptr->in_scope(this))) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  IIRScram_Declaration::_reset_scoping_prefix();
}


void 
IIRScram_ConstantDeclaration::_publish_cc_init() {
  if(_is_implicit_declaration())  {
    if ((_get_declarative_region() != NULL) && (_get_declarative_region()->get_kind() == IIR_CONCURRENT_GENERATE_FOR_STATEMENT)) {
      ((IIR_ConcurrentGenerateForStatement *) _get_declarative_region())->_publish_cc_init(_current_publish_node);
    }
    return;
  }
  if (get_value() == NULL) {
    switch(get_subtype()->get_kind()) {
    case IIR_ARRAY_TYPE_DEFINITION :
    case IIR_ARRAY_SUBTYPE_DEFINITION:
    case IIR_RECORD_TYPE_DEFINITION:
      _publish_cc_composite_init();
      break;
    case IIR_ACCESS_TYPE_DEFINITION:
    case IIR_ACCESS_SUBTYPE_DEFINITION:
      _publish_cc_access_init();
      break;
    case IIR_FILE_TYPE_DEFINITION:
      _publish_cc_file_init();
      break;
    default:
      _publish_cc_scalar_init();
    }
  }
}


void
IIRScram_ConstantDeclaration::_publish_cc_constant_object_init() {
  if(get_subtype()->get_kind() == IIR_ACCESS_TYPE_DEFINITION ||
     get_subtype()->get_kind() == IIR_ACCESS_SUBTYPE_DEFINITION) {
    return;
  }
  _publish_cc();
  _publish_cc_constructor_args();
}

    
void
IIRScram_ConstantDeclaration::_publish_cc_initialization_value() {
  _publish_cc();
}


void
IIRScram_ConstantDeclaration::_publish_cc_scalar_init() {
  _publish_cc();
  _cc_out << " = ";
  get_subtype()->_publish_cc_left();
  _cc_out << ";" << endl;
}


void
IIRScram_ConstantDeclaration::_publish_cc_composite_init() {
  if(get_value() != NULL) {
    _publish_cc(); 
    //The following line will be added eventually
    //_cc_out << ".val";
    _cc_out << " = ";
    get_value()->_publish_cc();
    _cc_out << ";" << endl;
  }
}


void
IIRScram_ConstantDeclaration::_publish_cc_access_init() {
  _publish_cc();
  _cc_out << ".val = ";
  _cc_out << "NULL";
  _cc_out << ";" << endl;
}


void
IIRScram_ConstantDeclaration::_publish_cc_data() {
  _publish_cc_prefix_string();
  _publish_cc();
}


void
IIRScram_ConstantDeclaration::_publish_cc_wait_data() {
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  _cc_out << "s->";
  _publish_cc();
}


void
IIRScram_ConstantDeclaration::_publish_cc_universal_value() {
  //Assumes it is called for only constants of scalar type
  //   if (cgen_sym_tab_ptr != NULL && !cgen_sym_tab_ptr->in_scope(this)) {
  //     cgen_sym_tab_ptr->add_declaration(this);
  //   }
  _cc_out << "((";
  get_subtype()->_publish_cc_universal_type();
  _cc_out << " &)";
  _publish_cc();
  _cc_out << ".object->readVal())";
}


// This method is necessary in for loop statements, where the value of the
// iterator is used inside the loop.
void
IIRScram_ConstantDeclaration::_publish_cc_value() {
  _cc_out << "(";
  _publish_cc_universal_value();
  _cc_out << ".val)";
}


void
IIRScram_ConstantDeclaration::_publish_cc_object_type() {
  _cc_out << "VARIABLE";
}


void
IIRScram_ConstantDeclaration::_publish_cc_file_init() {
  // Yet to do file declarations
  // I don't know if this function will ever be called
  cerr << "I do not know anything about file types yet!!  Aborting." << endl;
  abort();
}


void
IIRScram_ConstantDeclaration::_publish_cc_left() {
  get_subtype()->_publish_cc_left();
}


void
IIRScram_ConstantDeclaration::_publish_cc_right() {
  get_subtype()->_publish_cc_right();
}


void
IIRScram_ConstantDeclaration::_publish_cc_universal_left() {
  ASSERT(get_subtype()->_is_scalar_type() == TRUE);
  ((IIR_ScalarTypeDefinition *) get_subtype())->_publish_cc_universal_left();
}


void
IIRScram_ConstantDeclaration::_publish_cc_universal_right() {
  ASSERT(get_subtype()->_is_scalar_type() == TRUE);
  ((IIR_ScalarTypeDefinition *) get_subtype())->_publish_cc_universal_right();
}


IIR_Boolean
IIRScram_ConstantDeclaration::_is_ascending_range() {
  return get_subtype()->_is_ascending_range();
}


// Why is this method in this class??  Look at IIRScram_ConstantDeclaration.hh
IIR_Boolean
IIRScram_ConstantDeclaration::_is_range_attribute() {
  ASSERT(get_subtype() != NULL);
  if(get_subtype()->_get_attribute() != NULL &&
     (get_subtype()->_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE ||
      get_subtype()->_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE ) ){
    return TRUE;
  } else {
    return FALSE;
  }
}


// This method checks if this constant declaration is the iterator of a
// for loop statement.
IIR_Boolean
IIRScram_ConstantDeclaration::_is_implicit_declaration() {
  ASSERT(_get_declarative_region() != NULL);

  if(_get_declarative_region()->get_kind() == IIR_FOR_LOOP_STATEMENT) {
    return TRUE;
  } else if (_get_declarative_region()->get_kind() == IIR_CONCURRENT_GENERATE_FOR_STATEMENT) {
    return TRUE;
  }
  else {
    return FALSE;
  }
}


IIR_Boolean
IIRScram_ConstantDeclaration::_is_static_expression() {
  if (_get_declarative_region()->get_kind() == IIR_CONCURRENT_GENERATE_FOR_STATEMENT) {
    return TRUE;
  }
  
  return (!_is_implicit_declaration());
}


IIR_Boolean 
IIRScram_ConstantDeclaration::_is_locally_static_primary(){
  if( _is_implicit_declaration() == FALSE && 
      get_value() != NULL && get_value()->_is_locally_static_primary() == TRUE ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}


IIR_Boolean 
IIRScram_ConstantDeclaration::_is_globally_static_primary(){
  // Inferred from rules given in c), d), and e), pg 109 of the LRM.
  return TRUE;
}


IIR_Attribute*
IIRScram_ConstantDeclaration::_get_attribute(){
  ASSERT(get_subtype() != NULL);

  return get_subtype()->_get_attribute();
}


IIRScram_Declaration::declaration_type 
IIRScram_ConstantDeclaration::_get_type(){
  return CONSTANT;
}


void
IIRScram_ConstantDeclaration::_publish_cc_init_package_constant(){
  ASSERT(_get_declarative_region()->get_kind() == IIR_PACKAGE_DECLARATION ||
	 _get_declarative_region()->get_kind() ==IIR_PACKAGE_BODY_DECLARATION);
  if(get_value() == NULL) {
    // This is a deffered constant initialization.  We will leave it as it
    // is now.  When the constant is initialized in the packgae body, code
    // will be generated for it.
    return;
  }
  if(get_subtype()->_is_scalar_type() == TRUE ||
     get_subtype()->_is_array_type() == TRUE || get_subtype()->_is_record_type() == TRUE ) {
    if (get_subtype()->_is_scalar_type() == TRUE &&
	get_subtype()->_is_kernel_type() == FALSE){
      get_subtype()->_publish_cc_kernel_type();
    }
    else {
      get_subtype()->_publish_cc_type_name();
    }
    _cc_out << " ";
    //     ((IIR_PackageDeclaration *) _get_declarative_region())->_publish_cc_package_name();
    //     _cc_out << "::";
    _publish_cc();
    _cc_out << "(ObjectBase::VARIABLE, ";
    if(get_subtype()->_is_scalar_type() == TRUE) {
      _cc_out << "(";
      get_subtype()->_publish_cc_kernel_type();
      _cc_out << ") ";
    }
    get_value()->_publish_cc();
    _cc_out << ");" << endl;
  } else {
    cerr << "IIRScram_ConstantDeclaration::_publish_cc_init_package_constant:"
	 << " Unknown subtype!" << endl;
  }
}


void
IIRScram_ConstantDeclaration::_publish_cc_state_object_init() {
  // Initialization not required for access types.
  _publish_cc_constant_object_init();
  _cc_out << ", ";
}


void 
IIRScram_ConstantDeclaration::_publish_cc_headers() {
  get_subtype()->_publish_cc_headers();
  if(get_value() != NULL) {
    get_value()->_publish_cc_headers();
  }
}

void
IIRScram_ConstantDeclaration::_publish_cc_decl_with_constructor_args(){
  switch(get_subtype()->get_kind()) {
  case IIR_ARRAY_TYPE_DEFINITION :
  case IIR_ARRAY_SUBTYPE_DEFINITION:
  case IIR_RECORD_TYPE_DEFINITION:
    get_subtype()->_publish_cc();
    _cc_out << " ";
    _publish_cc();
    break;
  case IIR_ACCESS_TYPE_DEFINITION:
  case IIR_ACCESS_SUBTYPE_DEFINITION:
    //This will be called eventually
    //get_subtype()->_publish_cc();
    _cc_out << "  AccessVariable<char*> ";
    // _cc_out <<  " " << *get_declarator();
    _cc_out << " ";
    _publish_cc();
    break;
  case IIR_FILE_TYPE_DEFINITION:
    get_subtype()->_publish_cc();
    break;
  default:
    _cc_out << "  ";
    get_subtype()->_publish_cc_type_name();
    // _cc_out <<  " " << *get_declarator() << ";" << endl;
    _cc_out << " ";
    _publish_cc();
    break;
  }

  _publish_cc_constructor_args();
  _cc_out << ";" << endl;
}


IIR*
IIRScram_ConstantDeclaration::_clone() {
  return this;
}
