// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Umesh Kumar V.Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_InstanceNameAttribute.cc,v 1.2 1999/03/09 20:55:00 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_InstanceNameAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_ConstantDeclaration.hh"
#include "StandardPackage.hh"
#include "IIR_ArrayTypeDefinition.hh"

IIRScram_InstanceNameAttribute::~IIRScram_InstanceNameAttribute() {}

void 
IIRScram_InstanceNameAttribute::_publish_vhdl(ostream &_vhdl_out) {
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'INSTANCE_NAME";
}


void 
IIRScram_InstanceNameAttribute::_publish_cc() {
  _cc_out << "instance_name(";
  get_prefix()->_publish_cc();
  _cc_out << ")";
}


IIR_TextLiteral *
IIRScram_InstanceNameAttribute::_build_attribute_name() {
  char *name = "instancename";
  return IIR_Identifier::get( name, strlen(name) );
}


IIR_TypeDefinition *
IIRScram_InstanceNameAttribute::_get_subtype(){
  return StandardPackage::string_type;
}

IIR_Declaration *
IIRScram_InstanceNameAttribute::_get_implicit_declaration( char *name,
							   IIR_TypeDefinition *type ){
  return _build_constant_declaration( name, type );
}
