#ifndef IIRSCRAM_SIGNAL_DECLARATION_HH
#define IIRSCRAM_SIGNAL_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SignalDeclaration.hh,v 1.2 1999/03/09 20:56:38 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_SignalDeclaration.hh"

class IIR_List;
template <class type> class set;
class IIR_TypeDefinition;
class IIR_DesigantorList;
class IIR_SignalDeclaration;

class IIRScram_SignalDeclaration : public IIRBase_SignalDeclaration {
// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_vhdl_decl(ostream &);
  IIR_SignalKind _get_signal_kind();
  
  void _publish_cc();
  void _publish_cc_decl();
  void _publish_cc_sigdest();
  void _publish_cc_init();
  void _publish_cc_data();
  void _publish_cc_elaborate();
  void _publish_cc_wait_data();
  void _publish_cc_init_signal();
  void _publish_cc_state_object_init();
  void _publish_cc_object_type();
  void _publish_cc_initialization_value() { _publish_cc(); }

  IIR_Boolean _is_guard_signal();
  
  //This function publishes the implicit signal attributes
  //that are in scope for "this" declaration
  //  void _publish_cc_implicit_signal_attributes();

  IIR_Boolean _is_signal(){ return TRUE; }
  IIR_Boolean _is_readble(){ return TRUE; }
  IIR_Boolean _is_writable(){ return TRUE; }


  IIR_Boolean _have_added_driver() {
    return _driver_addition_flag;
  }

  void _set_driver_addition_flag(IIR_Boolean val) {
    _driver_addition_flag = val;
  }

  IIR_Boolean _is_passed_through_out_port() {
    return _passed_through_out_port;
  }

  void _set_passed_through_out_port(IIR_Boolean val) {
    _passed_through_out_port = val;
  }

  virtual void _publish_cc_necessary_copying();
  virtual void _publish_cc_read_or_write(const char *, const char *);
  
  declaration_type _get_type();
  IIR_Declaration* _get_signal_decl();

  IIR *_clone();
  IIR_SignalDeclaration *_my_clone;

protected:
  IIRScram_SignalDeclaration();
  virtual ~IIRScram_SignalDeclaration() = 0;
  
private:
  IIR_Boolean _driver_addition_flag;
  IIR_Boolean _passed_through_out_port;
};
#endif





