
#ifndef IIRSCRAM_TYPE_DEFINITION_HH
#define IIRSCRAM_TYPE_DEFINITION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_TypeDefinition.hh,v 1.3 1999/08/02 12:50:07 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_TypeDefinition.hh"

class IIR_ScalarTypeDefinition;
class IIR_FunctionDeclaration;
class IIR_RangeTypeDefinition;
class IIR_Name;
class ostream;
class IIR_Attribute;
class IIR_TypeDeclaration;
class IIR_ElementDeclarationList;

class IIRScram_TypeDefinition : public IIRBase_TypeDefinition {

public:
  virtual void _publish_vhdl(ostream &);
  virtual void _publish_vhdl_decl(ostream &);
  virtual void _publish_vhdl_range(ostream &);
  virtual void _publish_vhdl_constraint(ostream &);
  
  // c++ code generation methods
  virtual IIR_Boolean _is_access_type() { return FALSE; }
  virtual IIR_Boolean _is_record_type() { return FALSE; }
  virtual IIR_Boolean _is_resolved() { return TRUE; }
  virtual IIR_Boolean _is_discrete_type() { return FALSE; }
  virtual IIR_Boolean _is_numeric_type() { return FALSE; }
  virtual IIR_Boolean _is_floating_type() { return FALSE; }
  virtual IIR_Boolean _is_integer_type() { return FALSE; }
  virtual IIR_Boolean _is_physical_type() { return FALSE; }
  virtual IIR_Boolean _is_enumeration_type() { return FALSE; }
  virtual IIR_Boolean _is_character_type() { return FALSE; }
  virtual IIR_Boolean _is_anonymous();
  virtual IIR_Boolean _is_bit_type();
  virtual IIR_Boolean _is_line_type();
  virtual IIR_Boolean _is_boolean_type();
  virtual IIR_Boolean _is_file_type() {return FALSE;}
  virtual IIR_Boolean _is_single_dimensional_array_type(){ return FALSE; }
  virtual IIR_Boolean _is_incomplete_type_definition(){ return FALSE; }
  virtual IIR_Boolean _designates_incomplete_type(){ return FALSE; }

  //The following function return TRUE if the elements of the
  //array type or any field of record type is an access type
  virtual IIR_Boolean _has_access_type() { return FALSE; }

  virtual IIR_Boolean _is_ascending_range();
  virtual IIR_Boolean _is_subtype();
  virtual IIR_Boolean _is_subtype_decl();
  
  virtual IIR_Boolean _is_element();
  virtual IIR_Boolean _is_resolved_type();

  virtual IIR_Boolean _is_iir_type_definition() { return TRUE; }
  virtual IIR_Boolean _is_kernel_type();
  IIR_Boolean _is_TypeDefinition() { return TRUE;}

  virtual void _publish_cc_left();
  virtual void _publish_cc_right();
  virtual void _publish_cc_decl_hh();
  virtual void _publish_cc_decl_cc();
  virtual void _publish_cc_type_name();
  virtual void _publish_cc_base_type_name();
  virtual void _publish_cc_decl_type_attributes();
  virtual void _publish_cc_universal_left();
  virtual void _publish_cc_bounds();

  virtual void _publish_cc();
  
  //The following function publishes the predefined functions
  //and operator's prototype for the VHDL Types
  virtual void _publish_cc_decl_operators_prototypes();

  virtual void _publish_cc_decl_relational_operators_prototypes();
  virtual void _publish_cc_decl_arithmetic_operators_prototypes();
  virtual void _publish_cc_decl_predefined_procedures_prototypes();
  
  virtual void _publish_cc_unaryplus_operator_prototype();
  virtual void _publish_cc_unaryminus_operator_prototype();
  virtual void _publish_cc_plus_operator_prototype();
  virtual void _publish_cc_minus_operator_prototype();
  virtual void _publish_cc_abs_operator_prototype();
  virtual void _publish_cc_concatenation_operator_prototype();
  virtual void _publish_cc_multiply_operator_prototype();
  virtual void _publish_cc_divide_operator_prototype();
  virtual void _publish_cc_pow_operator_prototype();
  virtual void _publish_cc_mod_operator_prototype();
  virtual void _publish_cc_rem_operator_prototype();    

  virtual void _publish_cc_decl_operators();
  void _publish_cc_function_leftvalue();
  virtual void _publish_cc_decl_relational_operators();
  virtual void _publish_cc_decl_arithmetic_operators();
  virtual void _publish_cc_unaryplus_operator();
  virtual void _publish_cc_unaryminus_operator();
  virtual void _publish_cc_plus_operator();
  virtual void _publish_cc_minus_operator();
  virtual void _publish_cc_abs_operator();
  virtual void _publish_cc_concatenation_operator();
  virtual void _publish_cc_multiply_operator();
  virtual void _publish_cc_divide_operator();
  virtual void _publish_cc_pow_operator();
  virtual void _publish_cc_mod_operator();
  virtual void _publish_cc_rem_operator();

  virtual void _publish_cc_equality_operator();
  virtual void _publish_cc_inequality_operator();
  virtual void _publish_cc_lessthan_operator();
  virtual void _publish_cc_lessThanOrEqualto_operator();
  virtual void _publish_cc_greaterThan_operator();
  virtual void _publish_cc_greaterThanOrEqualto_operator();
  virtual void _publish_cc_necessary_decl_in_state();
  virtual void _publish_cc_init_fields_for_signals();
  
  void _publish_cc_equality_operator_prototype();
  void _publish_cc_inequality_operator_prototype();
  void _publish_cc_lessthan_operator_prototype();
  void _publish_cc_lessThanOrEqualto_operator_prototype();
  void _publish_cc_greaterThan_operator_prototype();
  void _publish_cc_greaterThanOrEqualto_operator_prototype();

  virtual void _publish_cc_constructor_args();
  virtual void _publish_cc_subelement_type();
  virtual void _publish_cc_anonymous_type_name();
  virtual void _publish_cc_type_info();
  virtual void _publish_cc_object_type_info();
  virtual void _publish_cc_extern_type_info();
  virtual void _publish_cc_type_string(){}
  virtual void _publish_cc_init_val() {
    _report_undefined_scram_fn("_publish_cc_init_val()");
  }

  virtual void _publish_cc_headers();
  virtual void _publish_cc_typeInfo();
  virtual void _publish_cc_class();
  virtual void _publish_cc_parent_type_name();
  virtual void _publish_cc_data_members();

  virtual void _publish_cc_decl_constructors();
  virtual void _publish_cc_type_constructors();
  virtual void _publish_cc_subtype_constructors();

  virtual void _publish_cc_decl_destructors();
  virtual void _publish_cc_type_destructors();
  virtual void _publish_cc_subtype_destructors();

  virtual void _publish_cc_type_operator_equalto();
  virtual void _publish_cc_decl_operator_subscript();
  virtual void _publish_cc_subtype_operator_equalto();
  virtual void _publish_cc_decl_operator_equalto();

  virtual void _publish_cc_kernel_type();

  virtual void _publish_cc_elaborate();
  virtual void _publish_cc_class_event();
  virtual void _publish_cc_class_last_event();

  void _publish_cc_set_resolution_function();

  void _add_decl_into_cgen_symbol_table();

  //These functions publishes the code needed in the 
  //initializtion of any signal
  //These functions unrolls the composite type to their individual 
  // non composite types
  virtual void _publish_cc_init_signal();  

  //These functions publishes the code needed in the 
  //initializtion of any variable
  //These functions unrolls the composite type to their individual 
  // non composite types
  virtual void _publish_cc_composite_init();  

  //This function publishes the range of the type if it is scalar type
  //and publishes the range of indices, if it is an array type
  virtual void _publish_cc_range();
  
  IIR_TypeDefinition *_get_bottom_base_type();
  
  // This method returns a pointer to the most constrained common subtype
  // of "this" type, and the one passed in.  It returns NULL if the types
  // are not compatible at all.
  IIR_TypeDefinition *_is_compatible( IIR_TypeDefinition * );
  virtual IIR_TypeDefinition *_check_special_compatible( IIR_TypeDefinition * );

  // If this type is not anonymous, it prints declaration's name.
  // Otherwise, it prints "ANONYMOUS".
  IIR_TextLiteral *_get_declarator();

  virtual IIR *_get_direction();

  virtual IIR_TypeDefinition* _get_base_type();

  // A scalar subtype may return NULL as it's left even if it has a range
  // constraint.  These methods will travel down to the first base type
  // that has a left defined.  Similarly for right and direction.
  virtual IIR* _get_base_type_left();
  virtual IIR* _get_base_type_direction();
  virtual IIR* _get_base_type_right();

  // If this is a record type (or an access to a record type?), it returns
  // it's element list.  Otherwise it returns NULL.
  virtual IIR_ElementDeclarationList *_get_element_declarations(){ return NULL; }

  // If this is an array type (or an access to an array type?), returns
  // it's element subtype.  Otherwise, it complains and aborts!
  virtual IIR_TypeDefinition *_get_element_subtype();
  virtual IIR_ScalarTypeDefinition *_get_index_subtype();
  virtual void _set_index_subtype(  IIR_ScalarTypeDefinition * );
  virtual void _set_element_subtype(  IIR_TypeDefinition * );
  virtual IIR_Int32 _get_num_indexes();
  virtual IIR_TypeDefinition *_get_type_of_element( int );

  virtual IIR_TypeDefinition* _is_explicit_type_conversion_needed(IIR_TypeDefinition *);
  virtual IIR_Boolean _is_base_type(IIR_TypeDefinition *);
  
  virtual IIR_Boolean _is_array_type(){
    return FALSE;
  }

  virtual IIR_Boolean _is_unconstrained_array_type(){
    return FALSE;
  }

  ostream &_print( ostream & );

  virtual set<IIR_Declaration> *_find_declarations( IIR_Name * );
  virtual set<IIR_Declaration> *_find_declarations( IIR_TextLiteral * );
  
  IIR_Boolean _is_type_definition() { return TRUE; };

  // This method takes a range type definition, and constructs an anonymous 
  // IIR_IntegerTypeDefinition, IIR_FloatingTypeDefinition. It allocates memory to
  // hand back to the caller!
  static IIR_ScalarTypeDefinition *_construct_new_type( IIR_RangeTypeDefinition * );

  set<IIR_TypeDefinition> *_get_rval_set( IIR_Boolean (IIR::*constraint_function)() = 0 );
  void _type_check( set<IIR_TypeDefinition> * );

  // XXX The spec is broken, and it's impossible to stick an
  // IIR_RangeAttibute in some places that it needs to be.  In order
  // to get around, scram is going to temporarily shove it into here. 
  // 5/29/97 Dale
  IIR_Attribute *_get_attribute(){ return my_attribute; }
  void _set_attribute( IIR_Attribute *tmp_attr ){ my_attribute = tmp_attr; }

  virtual IIR_TypeDefinition *
  _construct_new_subtype( IIR_Name *resolution_function,
			  IIR_ScalarTypeDefinition *new_constraint );

  virtual IIR_TypeDefinition *_get_new_subtype();

  static IIR_FunctionDeclaration *_resolve_resolution_function( IIR_Name * );

  virtual IIR_FunctionDeclaration *_get_resolution_function();
  virtual void _set_resolution_function( IIR_FunctionDeclaration * );

  IIR_TypeDefinition *
  _construct_new_subtype_resolution_function_only( IIR_Name *resolution_function,
			  IIR_ScalarTypeDefinition *new_constraint );

  IIR *_clone( );
  void _clone( IIR_TypeDefinition * );
  
  virtual IIR_Boolean is_element();
  virtual void set_is_element( IIR_Boolean );  
  
  // This gives a type a chance to build operators, functions, and do
  // other housekeeping.
  virtual void _come_into_scope( symbol_table *, IIR_TypeDeclaration * );
  virtual void _come_out_of_scope( symbol_table * ){}

protected:
  IIRScram_TypeDefinition();

  virtual ~IIRScram_TypeDefinition() = 0;

  virtual void _build_implicit_operators( set<IIR_Declaration> *add_to );
  void _build_implicit_operator( char *op,
				 set<IIR_Declaration> *add_to,
				 IIRScram_TypeDefinition *return_type, 
				 IIRScram_TypeDefinition *left_type,
				 IIRScram_TypeDefinition *right_type = NULL );

  void _build_implicit_operators( char *ops[],
				  set<IIR_Declaration> *add_to,
				  IIRScram_TypeDefinition *return_type,
				  IIRScram_TypeDefinition *left_type,
				  IIRScram_TypeDefinition *right_type = NULL );

  void _build_logical_operators( set<IIR_Declaration> *add_to );
  void _build_ordering_operators( set<IIR_Declaration> *add_to );

private:
  static IIR_ScalarTypeDefinition *_determine_type_of_bound( IIR *left_or_right );

  IIR_Attribute *my_attribute;
};
#endif
