// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIR_QuietAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_PhysicalLiteral.hh"
#include "IIR_EnumerationSubtypeDefinition.hh"
#include "resolution_func.hh"
#include "symbol_table.hh"
#include "StandardPackage.hh"
#include "savant.hh"
#include "published_file.hh"

extern symbol_table *cgen_sym_tab_ptr;


IIRScram_QuietAttribute::~IIRScram_QuietAttribute() {}

void 
IIRScram_QuietAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'QUIET";

  if (get_suffix() != NULL) {
    _vhdl_out << "(";
    get_suffix()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ") ";
  }
}

IIR_Boolean 
IIRScram_QuietAttribute::_is_readable(){
  return get_prefix()->_is_readable();
}


// The Quiet attribute is a boolean signal valued attribute...
IIR_TypeDefinition *
IIRScram_QuietAttribute::get_subtype(){
  return StandardPackage::get_boolean_type();
}

IIR_TextLiteral *
IIRScram_QuietAttribute::_build_attribute_name(){
  char *name = "quiet";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_Declaration *
IIRScram_QuietAttribute::_get_implicit_declaration( const string &decl_name,
						    IIR_TypeDefinition *decl_type ){ 
  return (IIR_Declaration*)_build_signal_declaration( decl_name, decl_type );
}

void
IIRScram_QuietAttribute::_publish_cc_lvalue( published_file &_cc_out ) {
  _publish_cc_signal_attribute( _cc_out, "Quiet", TRUE );
}

// For QUIET attribute to work, VHDLKernel requires LAST_ACTIVE attribute.
// This is taken care of here.  If we find a QUIET attribute, we also
// define a LAST_ACTIVE attribute which is used to compute S'QUIET.
void
IIRScram_QuietAttribute::_publish_cc_necessary_decl_in_state( published_file &_cc_out ) {
  _publish_cc_necessary_signal_decl_in_state( _cc_out, QUIET, "_quiet");
  _publish_cc_necessary_signal_decl_in_state( _cc_out, LAST_ACTIVE, "_last_active");
}

// Initialization value of the signal, in UserState::initstate()
void
IIRScram_QuietAttribute::_publish_cc_init_val( published_file &_cc_out ) { 
  _cc_out << "true";
}

void
IIRScram_QuietAttribute::_publish_cc_name_in_caps( published_file &_cc_out ) {
  _cc_out << "QUIET";
}

void
IIRScram_QuietAttribute::_publish_cc_attrib_type( published_file &_cc_out ) {
  _cc_out << "signal";
}

// This method initializes the LAST_ACTIVE attribute declared by the
// kernel.
void
IIRScram_QuietAttribute::_publish_cc_necessary_decl_init( published_file &_cc_out ) {
  _publish_cc_necessary_signal_init( _cc_out, QUIET, "_quiet", TRUE );
  _publish_cc_necessary_signal_init( _cc_out, LAST_ACTIVE, "_last_active" );
}


void
IIRScram_QuietAttribute::_publish_cc_elaborate( published_file &_cc_out ){
  get_prefix()->_publish_cc_elaborate( _cc_out );
  _cc_out << "_quiet";
}


void
IIRScram_QuietAttribute::_publish_cc_sigtype( published_file &_cc_out ) {
  _cc_out << " I_QUIET;\n";
}


void
IIRScram_QuietAttribute::_publish_cc_type_cast( published_file &_cc_out ) {
  _cc_out << "(Signal<UniversalInteger>* ) ";
}

IIR*
IIRScram_QuietAttribute::_clone() {
  IIR_QuietAttribute *clone = new IIR_QuietAttribute;
  IIR_Attribute::_clone(clone);
  clone->set_suffix(get_suffix());
  return clone;
}


void 
IIRScram_QuietAttribute::_publish_cc_state_object_init( published_file &_cc_out ) {
  _publish_cc_necessary_signal_state_object_init( _cc_out, QUIET, "_quiet", TRUE );
  _publish_cc_necessary_signal_state_object_init( _cc_out, LAST_ACTIVE, "_last_active" );
}

void 
IIRScram_QuietAttribute::_publish_cc_necessary_copying( published_file &_cc_out ) {
  _publish_cc_necessary_attribute_copying( _cc_out, QUIET, "_quiet" );
  _publish_cc_necessary_attribute_copying( _cc_out, LAST_ACTIVE, "_last_active" );
}

void 
IIRScram_QuietAttribute::_publish_cc_read_or_write( published_file &_cc_out,
						    const string &fName, 
						    const string &sName) {
  _publish_cc_attribute_read_or_write( _cc_out, QUIET, "_quiet", fName, sName);
  _publish_cc_attribute_read_or_write( _cc_out, LAST_ACTIVE, "_last_active", fName, sName);
}


void  
IIRScram_QuietAttribute::_resolve_suffix_special() {
  _resolve_suffix_non_negative_time();
}

visitor_return_type *IIRScram_QuietAttribute::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_QuietAttribute(this, arg);
};
