/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midlet;

import com.sun.midp.lcdui.Resource;
import com.sun.midp.midlet.MIDletInfo;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class Selector
extends MIDlet
implements CommandListener {
    private List mlist;
    private Display display;
    private int mcount;
    private boolean exitAfterLaunch = true;
    private MIDletInfo[] minfo;
    private Command backCmd = new Command(Resource.getString("Back"), 2, 2);
    private Command launchCmd = new Command(Resource.getString("Launch"), 8, 1);

    public Selector() {
        this(true);
    }

    public Selector(boolean exitFlag) {
        this.exitAfterLaunch = exitFlag;
        this.display = Display.getDisplay(this);
        this.mcount = 0;
        this.minfo = new MIDletInfo[20];
        this.readMIDletInfo();
    }

    public void startApp() {
        this.setupList();
        this.mlist.addCommand(this.launchCmd);
        if (this.exitAfterLaunch) {
            this.mlist.addCommand(this.backCmd);
        }
        this.mlist.setCommandListener(this);
        this.display.setCurrent(this.mlist);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable s) {
        if (s == this.mlist && c == List.SELECT_COMMAND || c == this.launchCmd) {
            int i = this.mlist.getSelectedIndex();
            String classname = this.minfo[i].classname;
            try {
                MIDlet m = (MIDlet)Class.forName(classname).newInstance();
                if (this.exitAfterLaunch) {
                    this.destroyApp(false);
                    this.notifyDestroyed();
                    return;
                }
                this.notifyPaused();
                this.resumeRequest();
                return;
            }
            catch (Exception ex) {
                StringBuffer sb = new StringBuffer().append(this.minfo[i].name).append(", ").append(classname).append("\n").append(Resource.getString("Exception")).append(": ").append(ex.toString());
                Alert a = new Alert(Resource.getString("Cannot start: "), sb.toString(), null, null);
                System.out.println("Unable to create MIDlet " + classname);
                ex.printStackTrace();
                this.display.setCurrent(a, this.mlist);
                return;
            }
        }
        if (c == this.backCmd) {
            this.destroyApp(false);
            this.notifyDestroyed();
            return;
        }
    }

    private void setupList() {
        if (this.mlist == null) {
            this.mlist = new List(Resource.getString("Select one to launch:"), 3);
            int i = 0;
            while (i < this.mcount) {
                Image icon = null;
                if (this.minfo[i].icon != null) {
                    try {
                        icon = Image.createImage(this.minfo[i].icon);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.mlist.append(" " + this.minfo[i].name, icon);
                ++i;
            }
        }
    }

    private void readMIDletInfo() {
        int n = 1;
        while (n < 100) {
            String nth = "MIDlet-" + n;
            String attr = this.getAppProperty(nth);
            if (attr == null || attr.length() == 0) break;
            this.addMIDlet(new MIDletInfo(attr));
            ++n;
        }
    }

    private void addMIDlet(MIDletInfo info) {
        if (this.mcount >= this.minfo.length) {
            MIDletInfo[] n = new MIDletInfo[this.mcount + 4];
            System.arraycopy(this.minfo, 0, n, 0, this.mcount);
            this.minfo = n;
        }
        this.minfo[this.mcount++] = info;
    }
}

