/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLUGIN_H__
#define __SG_PLUGIN_H__

#include <Python.h>

typedef struct _SGplugin SGplugin;

typedef gpointer (*SGPluginFunc)                        (SGplugin *plugin);

typedef enum {
  SG_PYTHON_PLUGIN,
  SG_C_PLUGIN
} SGPluginType;

struct _SGplugin {
  GtkWidget *menu_item;
  gchar *name;
  gchar *group;
  SGPluginFunc func;
  SGPluginType type;
};


void		sg_plugins_init				(void);
void		sg_plugins_free				(void);
void		sg_plugin_group_new			(gchar *group);
SGplugin	*sg_plugin_new_python			(gchar *name, 
							 gchar *group,
                                                         PyObject *callable);
SGplugin	*sg_plugin_new_c			(gchar *name, 
							 gchar *group,
                                                         SGPluginFunc c_func);
void 		sg_plugin_destroy			(SGplugin *plugin);
void 	        sg_plugin_exec				(SGplugin *plugin);
void 		sg_plugin_set_name			(SGplugin *plugin, 
							 gchar *name);
void 		sg_plugin_set_group			(SGplugin *plugin, 
							 gchar *group);

#endif /* __SG_PLUGIN_H__ */
