// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) DIGITEO - 2010-2010 - Clément DAVID <clement.david@scilab.org>
//
// This file is distributed under the same license as the Scilab package.

// <-- XCOS TEST -->
// <-- ENGLISH IMPOSED -->
//
// <-- Short Description -->
// White-box test for the xcosPalExport macro.

path = TMPDIR + "/palette.sod";

pal = xcosPal();

assert_checktrue(xcosPalExport(pal, path));
if ~isfile(path) then pause, end
deletefile(path);

[status, msg] = xcosPalExport(pal, path);
assert_checkequal(msg, "Success");
assert_checktrue(status);
if ~isfile(path) then pause, end
deletefile(path);

savedPal = pal;
assert_checktrue(xcosPalExport(pal, path));

clear pal;
load(path);
assert_checktrue(and(savedPal == pal));

