/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.5:
 *   smidump -f scli \
 *     --scli-include='dot1qBase|dot1qVlanStaticEntry' Q-BRIDGE-MIB
 *
 * Derived from Q-BRIDGE-MIB:
 *   The VLAN Bridge MIB module for managing Virtual Bridged
 *   Local Area Networks, as defined by IEEE 802.1Q-2003,
 *   including Restricted Vlan Registration defined by
 *   IEEE 802.1u-2001 and Vlan Classification defined by
 *   IEEE 802.1v-2001.
 *   
 *   Copyright (C) The Internet Society (2006).  This version of
 *   this MIB module is part of RFC 4363; See the RFC itself for
 *   full legal notices.
 *
 * Revision 2006-01-09 00:00:
 *   Added Vlan TEXTUAL-CONVENTIONs,
 *   dot1qPortRestrictedVlanRegistration, dot1vProtocol subtree,
 *   qBridgeClassificationDeviceGroup, qBridgePortGroup2,
 *   qBridgeClassificationPortGroup, and qBridgeCompliance2.
 *   Clarified dot1qForwardAllStaticPorts,
 *   qPortAcceptableFrameTypes, and qBridgeCompliance.
 *   Deprecated qBridgePortGroup and qBridgeCompliance.
 *
 * Revision 1999-08-25 00:00:
 *   The VLAN Bridge MIB module for managing Virtual Bridged
 *   Local Area Networks, as defined by IEEE 802.1Q-1998.
 *   
 *   Initial version, published as RFC 2674.
 *
 * $Id: q-bridge-mib.c 2078 2006-10-23 16:50:25Z schoenw $
 */

#include "q-bridge-mib.h"

GNetSnmpEnum const q_bridge_mib_enums_dot1qVlanVersionNumber[] = {
    { Q_BRIDGE_MIB_DOT1QVLANVERSIONNUMBER_VERSION1, "version1" },
    { 0, NULL }
};


static gint32 dot1qMaxVlanId_constraints[] = {1L, 4094L, 0, 0};
static guint16 dot1qVlanStaticName_constraints[] = {0U, 32U, 0, 0};


static guint32 const dot1qBase_oid[] = {1, 3, 6, 1, 2, 1, 17, 7, 1, 1};

static GNetSnmpAttribute dot1qBase_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      Q_BRIDGE_MIB_DOT1QVLANVERSIONNUMBER, "dot1qVlanVersionNumber",
       NULL,
      G_STRUCT_OFFSET(q_bridge_mib_dot1qBase_t, dot1qVlanVersionNumber),
      0,
      0 },
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      Q_BRIDGE_MIB_DOT1QMAXVLANID, "dot1qMaxVlanId",
       dot1qMaxVlanId_constraints,
      G_STRUCT_OFFSET(q_bridge_mib_dot1qBase_t, dot1qMaxVlanId),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      Q_BRIDGE_MIB_DOT1QMAXSUPPORTEDVLANS, "dot1qMaxSupportedVlans",
       NULL,
      G_STRUCT_OFFSET(q_bridge_mib_dot1qBase_t, dot1qMaxSupportedVlans),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      Q_BRIDGE_MIB_DOT1QNUMVLANS, "dot1qNumVlans",
       NULL,
      G_STRUCT_OFFSET(q_bridge_mib_dot1qBase_t, dot1qNumVlans),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      Q_BRIDGE_MIB_DOT1QGVRPSTATUS, "dot1qGvrpStatus",
       NULL,
      G_STRUCT_OFFSET(q_bridge_mib_dot1qBase_t, dot1qGvrpStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const dot1qVlanStaticEntry_oid[] = {1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1};

static GNetSnmpAttribute dot1qVlanStaticEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      Q_BRIDGE_MIB_DOT1QVLANSTATICNAME, "dot1qVlanStaticName",
       dot1qVlanStaticName_constraints,
      G_STRUCT_OFFSET(q_bridge_mib_dot1qVlanStaticEntry_t, dot1qVlanStaticName),
      G_STRUCT_OFFSET(q_bridge_mib_dot1qVlanStaticEntry_t, _dot1qVlanStaticNameLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 2, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      Q_BRIDGE_MIB_DOT1QVLANSTATICEGRESSPORTS, "dot1qVlanStaticEgressPorts",
       NULL,
      G_STRUCT_OFFSET(q_bridge_mib_dot1qVlanStaticEntry_t, dot1qVlanStaticEgressPorts),
      G_STRUCT_OFFSET(q_bridge_mib_dot1qVlanStaticEntry_t, _dot1qVlanStaticEgressPortsLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 3, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      Q_BRIDGE_MIB_DOT1QVLANFORBIDDENEGRESSPORTS, "dot1qVlanForbiddenEgressPorts",
       NULL,
      G_STRUCT_OFFSET(q_bridge_mib_dot1qVlanStaticEntry_t, dot1qVlanForbiddenEgressPorts),
      G_STRUCT_OFFSET(q_bridge_mib_dot1qVlanStaticEntry_t, _dot1qVlanForbiddenEgressPortsLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 4, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      Q_BRIDGE_MIB_DOT1QVLANSTATICUNTAGGEDPORTS, "dot1qVlanStaticUntaggedPorts",
       NULL,
      G_STRUCT_OFFSET(q_bridge_mib_dot1qVlanStaticEntry_t, dot1qVlanStaticUntaggedPorts),
      G_STRUCT_OFFSET(q_bridge_mib_dot1qVlanStaticEntry_t, _dot1qVlanStaticUntaggedPortsLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      Q_BRIDGE_MIB_DOT1QVLANSTATICROWSTATUS, "dot1qVlanStaticRowStatus",
       NULL,
      G_STRUCT_OFFSET(q_bridge_mib_dot1qVlanStaticEntry_t, dot1qVlanStaticRowStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};


q_bridge_mib_dot1qBase_t *
q_bridge_mib_new_dot1qBase()
{
    q_bridge_mib_dot1qBase_t *dot1qBase;

    dot1qBase = (q_bridge_mib_dot1qBase_t *) g_malloc0(sizeof(q_bridge_mib_dot1qBase_t) + sizeof(gpointer));
    return dot1qBase;
}

static inline q_bridge_mib_dot1qBase_t *
assign_dot1qBase(GList *vbl)
{
    q_bridge_mib_dot1qBase_t *dot1qBase;
    char *p;

    dot1qBase = q_bridge_mib_new_dot1qBase();
    p = (char *) dot1qBase + sizeof(q_bridge_mib_dot1qBase_t);
    * (GList **) p = vbl;

    gnet_snmp_attr_assign(vbl, dot1qBase_oid, G_N_ELEMENTS(dot1qBase_oid),
                      dot1qBase_attr, dot1qBase);

    return dot1qBase;
}

void
q_bridge_mib_get_dot1qBase(GNetSnmp *s, q_bridge_mib_dot1qBase_t **dot1qBase, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 0};

    *dot1qBase = NULL;

    gnet_snmp_attr_get(s, &in, base, 11, 10, dot1qBase_attr, mask);

    out = gnet_snmp_sync_getnext(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *dot1qBase = assign_dot1qBase(out);
    }
}

void
q_bridge_mib_set_dot1qBase(GNetSnmp *s, q_bridge_mib_dot1qBase_t *dot1qBase, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 0, 0};

    gnet_snmp_attr_set(s, &in, base, 12, 10, dot1qBase_attr, mask, dot1qBase);

    out = gnet_snmp_sync_set(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
q_bridge_mib_free_dot1qBase(q_bridge_mib_dot1qBase_t *dot1qBase)
{
    GList *vbl;
    char *p;

    if (dot1qBase) {
        p = (char *) dot1qBase + sizeof(q_bridge_mib_dot1qBase_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(dot1qBase);
    }
}

q_bridge_mib_dot1qVlanStaticEntry_t *
q_bridge_mib_new_dot1qVlanStaticEntry()
{
    q_bridge_mib_dot1qVlanStaticEntry_t *dot1qVlanStaticEntry;

    dot1qVlanStaticEntry = (q_bridge_mib_dot1qVlanStaticEntry_t *) g_malloc0(sizeof(q_bridge_mib_dot1qVlanStaticEntry_t) + sizeof(gpointer));
    return dot1qVlanStaticEntry;
}

static inline int
unpack_dot1qVlanStaticEntry(GNetSnmpVarBind *vb, q_bridge_mib_dot1qVlanStaticEntry_t *dot1qVlanStaticEntry)
{
    guint8 idx = 13;

    if (vb->oid_len < idx) return -1;
    dot1qVlanStaticEntry->dot1qVlanIndex = vb->oid[idx++];
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_dot1qVlanStaticEntry(guint32 *base, guint32 dot1qVlanIndex)
{
    guint8 idx = 13;

    base[idx++] = dot1qVlanIndex;
    return idx;
}

static inline q_bridge_mib_dot1qVlanStaticEntry_t *
assign_dot1qVlanStaticEntry(GList *vbl)
{
    q_bridge_mib_dot1qVlanStaticEntry_t *dot1qVlanStaticEntry;
    char *p;

    dot1qVlanStaticEntry = q_bridge_mib_new_dot1qVlanStaticEntry();
    p = (char *) dot1qVlanStaticEntry + sizeof(q_bridge_mib_dot1qVlanStaticEntry_t);
    * (GList **) p = vbl;

    if (unpack_dot1qVlanStaticEntry((GNetSnmpVarBind *) vbl->data, dot1qVlanStaticEntry) < 0) {
        g_warning("%s: invalid instance identifier", "dot1qVlanStaticEntry");
        g_free(dot1qVlanStaticEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, dot1qVlanStaticEntry_oid, G_N_ELEMENTS(dot1qVlanStaticEntry_oid),
                      dot1qVlanStaticEntry_attr, dot1qVlanStaticEntry);

    return dot1qVlanStaticEntry;
}

void
q_bridge_mib_get_dot1qVlanStaticTable(GNetSnmp *s, q_bridge_mib_dot1qVlanStaticEntry_t ***dot1qVlanStaticEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1, 0};

    *dot1qVlanStaticEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 13, 12, dot1qVlanStaticEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *dot1qVlanStaticEntry = (q_bridge_mib_dot1qVlanStaticEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(q_bridge_mib_dot1qVlanStaticEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*dot1qVlanStaticEntry)[i] = assign_dot1qVlanStaticEntry(row->data);
        }
    }
}

void
q_bridge_mib_get_dot1qVlanStaticEntry(GNetSnmp *s, q_bridge_mib_dot1qVlanStaticEntry_t **dot1qVlanStaticEntry, guint32 dot1qVlanIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, dot1qVlanStaticEntry_oid, sizeof(dot1qVlanStaticEntry_oid));
    len = pack_dot1qVlanStaticEntry(base, dot1qVlanIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "dot1qVlanStaticEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *dot1qVlanStaticEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 12, dot1qVlanStaticEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *dot1qVlanStaticEntry = assign_dot1qVlanStaticEntry(out);
    }
}

void
q_bridge_mib_set_dot1qVlanStaticEntry(GNetSnmp *s, q_bridge_mib_dot1qVlanStaticEntry_t *dot1qVlanStaticEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, dot1qVlanStaticEntry_oid, sizeof(dot1qVlanStaticEntry_oid));
    len = pack_dot1qVlanStaticEntry(base, dot1qVlanStaticEntry->dot1qVlanIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "dot1qVlanStaticEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 12, dot1qVlanStaticEntry_attr, mask, dot1qVlanStaticEntry);

    out = gnet_snmp_sync_set(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
q_bridge_mib_free_dot1qVlanStaticEntry(q_bridge_mib_dot1qVlanStaticEntry_t *dot1qVlanStaticEntry)
{
    GList *vbl;
    char *p;

    if (dot1qVlanStaticEntry) {
        p = (char *) dot1qVlanStaticEntry + sizeof(q_bridge_mib_dot1qVlanStaticEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(dot1qVlanStaticEntry);
    }
}

void
q_bridge_mib_free_dot1qVlanStaticTable(q_bridge_mib_dot1qVlanStaticEntry_t **dot1qVlanStaticEntry)
{
    int i;

    if (dot1qVlanStaticEntry) {
        for (i = 0; dot1qVlanStaticEntry[i]; i++) {
            q_bridge_mib_free_dot1qVlanStaticEntry(dot1qVlanStaticEntry[i]);
        }
        g_free(dot1qVlanStaticEntry);
    }
}


