#ifndef LINKVIEW_H
#define LINKVIEW_H

#include <gnome.h>

#include "page.h"

enum {
	GOODNODE = 1,
	EXTERNALNODE,
	BADNODE,
	NONODE,
	UPDATENODE,
	CHECKNODE
};

/* remote link status */
typedef enum {
	REMOTE_NOT_CHECKED = 0,
	REMOTE_EXISTS,
	REMOTE_UNREACHABLE,
	REMOTE_BROKEN,
	REMOTE_CHECKING
} RemoteStatus;

/* Must keep in sync with sitecopy's values */
typedef enum {
	file_unchanged, /* Remote file is same as local file */
	file_changed, /* File has changed locally, and should be uploaded */
	file_new, /* File is new locally, and should be uploaded */
	file_deleted,/* File deleted locally, and should be deleted remotely */
	file_moved /* File has been moved locally, should be moved remotely */
} SyncStatus;

typedef struct {
	gchar* name;		  /* Realtive Filename from the base node */
	gchar* filename;          /* Full File Name */
	gchar* remoteAddr; 	  /* If it is a link than then fill in this
				     field */
	gboolean exists; 	  /* Is it dead or not? */
	double filesize; 	  /* Filesize in bytes */

	struct ImageFileData* images;	 /* LL of images */
	SyncStatus uploadStatus;	 /* What the upload status is */
	gboolean excluded;		 /* is the page marked for upload?*/
	double drawnX;		   	 /* Where the node is located on the
					    linkview */
	double drawnY;
	GnomeCanvasItem *label;
	GnomeCanvasItem *icon;

	gpointer  handle;
	RemoteStatus status;
}HtmlFileData;

typedef struct {
	gchar* name;		/* Realtive Filename from the base node */
	gchar* filename;        /* Full File Name */
	gboolean external; 	/* Is it remote or local? */
	gboolean exists; 	/* Is it dead or not? */
	gboolean excluded;	/* is the page marked for upload?*/
	double filesize; 	/* Filesize in bytes */
	SyncStatus uploadStatus; /* What the upload status is */
	struct ImageFileData* nextImage;      /* pointer to the next image*/
}ImageFileData;

void screem_link_view_create( void );

GNode *build_link_tree( Page *page, const gchar *pathname, GNode *parent,
			gint level, 
			GHashTable *checked_files,
			GHashTable *upload_table );
void build_icons( GNode *node, GnomeCanvasGroup *root, gdouble root_x, 
		  gdouble root_y, gdouble root_angle, gint level, 
		  gint numOfNodesAtLevel, gint nthNode);
GnomeCanvasGroup* add_link_tree( GtkWidget *tree, GnomeCanvasGroup *root,
				 gdouble x, gdouble y );
void build_icon( GNode *node, GnomeCanvasGroup *root, 
		 gdouble x, gdouble y, gdouble angle, 
		 gdouble *width );
gint group_event( GnomeCanvasItem *item, GdkEvent *event, gchar *path );

void free_mem_from_html_node (GNode* node, gpointer data);
void free_mem_from_image_node (ImageFileData* node);
void remove_data (GNode* parent);
GNode* append_image_node( GNode *parent, ImageFileData *node);

void screem_link_view_sidebar_zoom ( GtkWidget *widget );
void screem_link_view_sidebar_switch_on( GtkWidget *widget );
void screem_link_view_sidebar_switch_off( GtkWidget *widget );
GnomeCanvasGroup* screem_link_view_add_key( GnomeCanvasGroup *root, gdouble x,
					    gdouble y);
void screem_link_view_stop_check( void );




#endif
