#ifndef MENUS_H
#define MENUS_H

#include <gnome.h>

#include "cvs.h"
#include "editor.h"
#include "editMenu.h"
#include "interface.h"
#include "page.h"
#include "pageUI.h"
#include "preferences.h"
#include "site.h"
#include "siteUI.h"
#include "siteTemplate.h"
#include "print.h"
#include "dtd.h"

extern void exit_confirm( void );

static GnomeUIInfo new_menu_item[] = {
        GNOMEUIINFO_MENU_NEW_ITEM( N_("_New Site..."), N_("Create a new site"),
                                   GTK_SIGNAL_FUNC( screem_site_create_site ),
				   NULL ),
        GNOMEUIINFO_MENU_NEW_ITEM( N_("_New Page..."), 
                                   N_("Create a new page (add if working on a site)"), 
                                   GTK_SIGNAL_FUNC( screem_page_create_page ),
				   NULL ),
	GNOMEUIINFO_MENU_NEW_ITEM( N_("_New Blank Page"),
				   N_("Create a blank page (add if working on a site)" ),
				   GTK_SIGNAL_FUNC( screem_page_create_blank_page ),
				   NULL ),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_NEW_ITEM( N_("_New Site Template"),
				   N_("Create a new site template"),
				   GTK_SIGNAL_FUNC( site_template_window ),
				   NULL ),
	GNOMEUIINFO_END
};

static GnomeUIInfo recent_sites_menu[] = {
	GNOMEUIINFO_END
};

static GnomeUIInfo recent_pages_menu[] = {
	GNOMEUIINFO_END
};

static GnomeUIInfo file_menu[] = {
        GNOMEUIINFO_MENU_NEW_SUBTREE( new_menu_item ),
        GNOMEUIINFO_SEPARATOR,
        { GNOME_APP_UI_ITEM, N_("_Open Site..."), N_("Open a site"),
          GTK_SIGNAL_FUNC( screem_site_open ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, GNOME_KEY_NAME_OPEN,
          GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Save Site"), N_("Save a site"),
	  GTK_SIGNAL_FUNC( screem_site_save_proxy ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, GNOME_KEY_NAME_SAVE,
          GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Save Site as..."), N_("Save site as"),
          GTK_SIGNAL_FUNC( screem_site_save_as ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS, 
	  GNOME_KEY_NAME_SAVE_AS, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Close Site"), N_("Close the current site"),
          GTK_SIGNAL_FUNC( screem_site_close_site ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, GNOME_KEY_NAME_CLOSE,
          GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SUBTREE( N_("_Recent Sites"), recent_sites_menu ),
        GNOMEUIINFO_SEPARATOR,
        { GNOME_APP_UI_ITEM, N_("_Open Page..."), N_("Open a single page"),
          GTK_SIGNAL_FUNC( screem_page_open ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0,
          GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Save Page"), N_("Save the current page"),
          GTK_SIGNAL_FUNC( screem_page_save_proxy ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 0,
          GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Save Page as..."), 
          N_("Save the current page as"),
          GTK_SIGNAL_FUNC( screem_page_save_as ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS, 0,
          GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Close Page"), N_("Close the current page"),
          GTK_SIGNAL_FUNC( screem_page_close_current ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0,
          GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SUBTREE( N_("_Recent Pages"), recent_pages_menu  ),
        GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_MENU_PRINT_ITEM( screem_print, 0 ),
        GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_MENU_EXIT_ITEM( exit_confirm, 0 ),
        GNOMEUIINFO_END
};

static GnomeUIInfo edit_menu[] = {
        GNOMEUIINFO_MENU_UNDO_ITEM( GTK_SIGNAL_FUNC( screem_editor_undo ), 0 ),
        GNOMEUIINFO_MENU_REDO_ITEM( GTK_SIGNAL_FUNC( screem_editor_redo ), 0 ),
        GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_MENU_CUT_ITEM( GTK_SIGNAL_FUNC( screem_editor_cut ), 0 ),
        GNOMEUIINFO_MENU_COPY_ITEM( GTK_SIGNAL_FUNC( screem_editor_copy ), 0 ),
        GNOMEUIINFO_MENU_PASTE_ITEM( GTK_SIGNAL_FUNC( screem_editor_paste ), 
				     0 ),
	{
		GNOME_APP_UI_ITEM, N_("Paste Encoded"),
		N_("Paste the clipboard, encoding html entities where needed"),
		GTK_SIGNAL_FUNC( screem_editor_paste_encoded ), 
		NULL, NULL, GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_PASTE, 0, GDK_CONTROL_MASK, NULL
	},
        GNOMEUIINFO_MENU_CLEAR_ITEM( GTK_SIGNAL_FUNC( screem_editor_clear_selection ), 0 ),
        GNOMEUIINFO_MENU_SELECT_ALL_ITEM( GTK_SIGNAL_FUNC( select_all ), 0 ),
        GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_MENU_FIND_ITEM( GTK_SIGNAL_FUNC( find ), 0 ),
        GNOMEUIINFO_MENU_REPLACE_ITEM( GTK_SIGNAL_FUNC( replace ), 0 ),
	{
		GNOME_APP_UI_ITEM, N_("Goto Line..."),
		N_("Move the cursor to the specified line"),
		GTK_SIGNAL_FUNC( screem_editor_goto_line ), 
		NULL, NULL, GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_JUMP_TO, 0, GDK_CONTROL_MASK, NULL
	},
     	GNOMEUIINFO_END
};
static GnomeUIInfo view_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Editor"),
		N_("Switch to the Editor view"),
		GTK_SIGNAL_FUNC( switch_to ),
		"0", NULL, GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_BLANK, 0, GDK_CONTROL_MASK, NULL
	
	},
	{
		GNOME_APP_UI_ITEM, N_("Preview"),
		N_("Switch to the Preview view"),
		GTK_SIGNAL_FUNC( switch_to ),
		"1", NULL, GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_BLANK, 0, GDK_CONTROL_MASK, NULL
	
	},
	{
		GNOME_APP_UI_ITEM, N_("Link"),
		N_("Switch to the Link view"),
		GTK_SIGNAL_FUNC( switch_to ),
		"2", NULL, GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_BLANK, 0, GDK_CONTROL_MASK, NULL
	
	},
	
        GNOMEUIINFO_SEPARATOR,
	{
		GNOME_APP_UI_TOGGLEITEM, N_("View Side Panel"),
		N_("Show/Hide the side panel"),
		GTK_SIGNAL_FUNC( show_hide ),
		"sitebook", NULL, GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_BLANK, 0, GDK_CONTROL_MASK, NULL
	
	},
	{
		GNOME_APP_UI_TOGGLEITEM, N_("View Messages"),
		N_("Show/Hide the messages"),
		GTK_SIGNAL_FUNC( show_hide ),
		"messages_book", NULL, GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_BLANK, 0, GDK_CONTROL_MASK, NULL
	
       	},
        GNOMEUIINFO_END
};

static GnomeUIInfo insert_menu[] = {
        GNOMEUIINFO_END
};

static GnomeUIInfo cvs_menu[] = {
        { GNOME_APP_UI_ITEM, N_("_Checkout site"), 
          N_("Obtain site from cvs"),
          GTK_SIGNAL_FUNC( cvs_checkout_site ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        { GNOME_APP_UI_ITEM, N_("_Update site"), 
          N_("Update local copy of site"),
          GTK_SIGNAL_FUNC( cvs_update_site ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        { GNOME_APP_UI_ITEM, N_("_Update page"),
          N_("Update local copy of page from CVS"),
          GTK_SIGNAL_FUNC( cvs_update_page ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        GNOMEUIINFO_SEPARATOR,
        { GNOME_APP_UI_ITEM, N_("_Import site..."),
          N_("Add the site to the cvs repository"),
          GTK_SIGNAL_FUNC( cvs_import_site ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        { GNOME_APP_UI_ITEM, N_("_Commit site..."),
          N_("Commit all changes made to site"),
	  GTK_SIGNAL_FUNC( cvs_commit_site ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        { GNOME_APP_UI_ITEM, N_("_Commit page..."),
          N_("Commit the current page"),
          GTK_SIGNAL_FUNC( cvs_commit_page ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        GNOMEUIINFO_END
};

static GnomeUIInfo tools_menu[] = {
	{ GNOME_APP_UI_ITEM, N_("Loaded DTDs"),
	  N_("DTDs supported by Screem"),
	  GTK_SIGNAL_FUNC( screem_loaded_dtds ), NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
	  GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Site Template Editor"),
	  N_("Edit a Site Template"),
          GTK_SIGNAL_FUNC( site_template_window ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        GNOMEUIINFO_SUBTREE( N_("_CVS"), cvs_menu ),
	GNOMEUIINFO_END
};

static GnomeUIInfo settings_menu[] = {
        { GNOME_APP_UI_ITEM, N_("_Site..."), 
          N_("Alter site settings"),
          GTK_SIGNAL_FUNC( screem_site_settings_dialog ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF, 0,
          GDK_CONTROL_MASK, NULL },
        GNOMEUIINFO_MENU_PREFERENCES_ITEM( GTK_SIGNAL_FUNC( edit_preferences ),
					   0 ),
        GNOMEUIINFO_END
};

extern void screem_startup_hint( void );
static GnomeUIInfo help_menu[] = {
        GNOMEUIINFO_MENU_ABOUT_ITEM( GTK_SIGNAL_FUNC( create_about ), 0 ),
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Tip of the Day..."),
	  N_("Show the Tip of the Day"),
          GTK_SIGNAL_FUNC( screem_startup_hint ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_HELP( "screem" ),
        GNOMEUIINFO_END
};

static GnomeUIInfo main_menu[] = {
        GNOMEUIINFO_MENU_FILE_TREE( file_menu ),
        GNOMEUIINFO_MENU_EDIT_TREE( edit_menu ),
	GNOMEUIINFO_MENU_VIEW_TREE( view_menu ),
        GNOMEUIINFO_SUBTREE( N_("_Insert"), insert_menu ),
	GNOMEUIINFO_SUBTREE( N_("_Tools" ), tools_menu ),
	GNOMEUIINFO_MENU_SETTINGS_TREE( settings_menu ),
        GNOMEUIINFO_MENU_HELP_TREE( help_menu ),
        GNOMEUIINFO_END
};


#endif
