;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/markup.sch                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Sep 24 05:58:26 2001                          */
;*    Last change :  Fri Nov 23 11:35:36 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    The macro that defines the DEFINE-MARKUP form.                   */
;*    -------------------------------------------------------------    */
;*    syntax:                                                          */
;*       DEFINE-MARKUP ::= (define-markup (<id> <BINDING>+) <expr>+)   */
;*       BINDING       ::= <symbol>                                    */
;*                       | <keyword>                                   */
;*                       | (<keyword> <expr>)                          */
;*                                                                     */
;*    example:                                                         */
;*       (define-markup (section :title (:number #f) . body) ...)      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    define-markup ...                                                */
;*---------------------------------------------------------------------*/
(define-pervasive-macro (define-markup proto . body)
   (define (keyword->symbol s)
      (let ((str (keyword->string s)))
	 (string->symbol (substring str 1 (string-length str)))))
   (define (plain-function? formals)
      (cond
	 ((not (pair? formals))
	  #t)
	 ((symbol? (car formals))
	  (plain-function? (cdr formals)))
	 (else
	  #f)))
   (define (markup-fun-vars id rest formals)
      (let loop ((formals formals))
	 (cond
	    ((null? formals)
	     rest)
	    ((symbol? formals)
	     rest)
	    ((not (pair? formals))
	     (error id "Illegal markup prototype" proto))
	    ((and (null? (cdr formals)) (symbol? (car formals)))
	     rest)
	    (else
	     (let ((a (car formals))
		   (r (cdr formals)))
		(cond
		   ((symbol? a)
		    (cons a (loop r)))
		   ((keyword? a)
		    (loop r))
		   ((and (pair? a)
			 (keyword? (car a))
			 (pair? (cdr a))
			 (null? (cddr a)))
		    (loop r))
		   (else
		    (error id "Illegal markup prototype" proto))))))))
   (define (markup-let-vars id rest formals)
      (let loop ((formals formals))
	 (cond
	    ((null? formals)
	     '())
	    ((symbol? formals)
	     (list `(,formals (check-rest ,rest))))
	    ((not (pair? formals))
	     (error "define-markup" "Illegal markup prototype" proto))
	    ((and (null? (cdr formals)) (symbol? (car formals)))
	     `((,(car formals) (check-rest (car ,rest)))
	       (,(gensym) (if (pair? (cdr ,rest))
			      (error ',id
				     "Extra parameter found"
				     ',(car formals))))))
	    (else
	     (let ((a (car formals))
		   (r (cdr formals)))
		(cond
		   ((symbol? a)
		    (loop r))
		   ((keyword? a)
		    (let ((bdg `(,(keyword->symbol a)
				 (let ((fetch (memq ,a ,rest)))
				    (if (and (pair? fetch) (pair? (cdr fetch)))
					(let ((val (cadr fetch)))
					   (set-cdr! fetch (cddr fetch))
					   (set! ,rest (delete! ,a ,rest))
					   val)
					(error ',id
					       ,(string-append
						 "Missing parameter `"
						 (keyword->string a)
						 "'")
					       ,rest))))))
		       (cons bdg (loop r))))
		   ((and (pair? a)
			 (keyword? (car a))
			 (pair? (cdr a))
			 (null? (cddr a)))
		    (let ((bdg `(,(keyword->symbol (car a))
				 (let ((fetch (memq ,(car a) ,rest)))
				    (if (and (pair? fetch) (pair? (cdr fetch)))
					(let ((val (cadr fetch)))
					   (set-cdr! fetch (cddr fetch))
					   (set! ,rest
						 (delete! ,(car a) ,rest))
					   val)
					,(cadr a))))))
		       (cons bdg (loop r))))
		   (else
		    (error "define-markup"
			   "Illegal markup prototype"
			   proto))))))))
   (match-case proto
      (((and (? symbol?) ?id) . ?formals) 
       (if (plain-function? formals)
	   `(define ,(cons id formals) ,@body)
	   (let ((rest (gensym 'rest)))
	      `(define ,(cons id (markup-fun-vars id rest formals))
		  (define (check-rest args)
		     (cond
			((pair? args)
			 (for-each (lambda (arg)
				      (if (keyword? arg)
					  (error ',id "Illegal keyword" arg)))
				   args))
			((keyword? args)
			 (error ',id "Illegal keyword" args)))
		     args)
		  (let* ,(markup-let-vars id rest formals)
		     ,@body)))))
      (else
       (error "define-markup" "Illegal form" proto))))
	    
;*---------------------------------------------------------------------*/
;*    define-lazy-markup ...                                           */
;*---------------------------------------------------------------------*/
(define-pervasive-macro (define-lazy-markup proto . body)
   (define (keyword->symbol s)
      (let ((str (keyword->string s)))
	 (string->symbol (substring str 1 (string-length str)))))
   (define (plain-function? formals)
      (cond
	 ((not (pair? formals))
	  #t)
	 ((symbol? (car formals))
	  (plain-function? (cdr formals)))
	 (else
	  #f)))
   (define (markup-fun-vars id rest formals)
      (let loop ((formals formals))
	 (cond
	    ((null? formals)
	     rest)
	    ((symbol? formals)
	     rest)
	    ((not (pair? formals))
	     (error id "Illegal markup prototype" proto))
	    ((and (null? (cdr formals)) (symbol? (car formals)))
	     rest)
	    (else
	     (let ((a (car formals))
		   (r (cdr formals)))
		(cond
		   ((symbol? a)
		    (cons a (loop r)))
		   ((keyword? a)
		    (loop r))
		   ((and (pair? a)
			 (keyword? (car a))
			 (pair? (cdr a))
			 (null? (cddr a)))
		    (loop r))
		   (else
		    (error id "Illegal markup prototype" proto))))))))
   (define (markup-let-vars id rest formals)
      (let loop ((formals formals))
	 (cond
	    ((null? formals)
	     '())
	    ((symbol? formals)
	     (list `(,formals ,rest)))
	    ((not (pair? formals))
	     (error "define-lazy-markup" "Illegal markup prototype" proto))
	    ((and (null? (cdr formals)) (symbol? (car formals)))
	     (list `(,(car formals) (car ,rest))))
	    (else
	     (let ((a (car formals))
		   (r (cdr formals)))
		(cond
		   ((symbol? a)
		    (loop r))
		   ((keyword? a)
		    (let ((bdg `(,(keyword->symbol a)
				 (let ((fetch (memq ,a ,rest)))
				    (if (and (pair? fetch) (pair? (cdr fetch)))
					(let ((val (cadr fetch)))
					   (set-cdr! fetch (cddr fetch))
					   (set! ,rest (delete! ,a ,rest))
					   val)
					(error ',id "Missing parameter" ,a))))))
		       (cons bdg (loop r))))
		   ((and (pair? a)
			 (keyword? (car a))
			 (pair? (cdr a))
			 (null? (cddr a)))
		    (let ((bdg `(,(keyword->symbol (car a))
				 (let ((fetch (memq ,(car a) ,rest)))
				    (if (and (pair? fetch) (pair? (cdr fetch)))
					(let ((val (cadr fetch)))
					   (set-cdr! fetch (cddr fetch))
					   (set! ,rest (delete! ,(car a) ,rest))
					   val)
					,(cadr a))))))
		       (cons bdg (loop r))))
		   (else
		    (error "define-lazy-markup"
			   "Illegal markup prototype"
			   proto))))))))
   (match-case proto
      (((and (? symbol?) ?id) . ?formals)
       (if (plain-function? formals)
	   `(define ,(cons id formals) ,@body)
	   (let (($id (symbol-append '$ id)))
	      (let ((rest (gensym 'rest)))
		 `(begin (define ,(cons $id (markup-fun-vars id rest formals))
			    (let* ,(markup-let-vars id rest formals)
			       ,@body))
			 ,(let ((m `(define-macro (,id . args)
				       (cons ',$id
					     (let loop ((args args)
							(res '()))
						(cond
						   ((null? args)
						    (reverse! res))
						   ((and (keyword? (car args))
							 (pair? (cdr args)))
						    (loop (cddr args)
							  (cons* (cadr args)
								 (car args)
								 res)))
						   (else
						    (loop (cdr args)
							  (cons `(delay ,(car args))
								res)))))))))
			     `(eval ',m)))))))
      (else
       (error "define-lazy-markup" "Illegal form" proto))))
	    
;*---------------------------------------------------------------------*/
;*    define-counter ...                                               */
;*---------------------------------------------------------------------*/
(define-macro (define-counter name)
   `(define ,name
       (let ((count 0))
	  (lambda (val)
	     (cond
		((string? val)
		 val)
		((number? val)
		 (set! count val)
		 val)
		(val
		 (set! count (+fx 1 count))
		 count)
		(else
		 #f))))))
