;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribehtml/tools.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 17 17:41:24 2001                          */
;*    Last change :  Tue Nov 20 06:10:51 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    Scribehtml Tools.                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribehtml_tools

   (library scribeapi)

   (export (html-string::bstring ::bstring)
	   (html-width::obj ::obj)
	   (generic title-number::bstring ::%node)))
	   
;*---------------------------------------------------------------------*/
;*    html-string ...                                                  */
;*---------------------------------------------------------------------*/
(define (html-string str)
   (let ((len (string-length str)))
      (let loop ((r 0)
		 (nlen len))
	 (if (=fx r len)
	     (if (=fx nlen len)
		 str
		 (let ((res (make-string nlen)))
		    (let loop ((r 0)
			       (w 0))
		       (if (=fx w nlen)
			   res
			   (let ((c (string-ref str r)))
			      (case c
				 ((#\<)
				  (blit-string! "&lt;" 0 res w 4)
				  (loop (+fx r 1) (+fx w 4)))
				 ((#\>)
				  (blit-string! "&gt;" 0 res w 4)
				  (loop (+fx r 1) (+fx w 4)))
				 ((#\&)
				  (blit-string! "&amp;" 0 res w 5)
				  (loop (+fx r 1) (+fx w 5)))
				 ((#\")
				  (blit-string! "&quot;" 0 res w 6)
				  (loop (+fx r 1) (+fx w 6)))
				 (else
				  (string-set! res w c)
				  (loop (+fx r 1) (+fx w 1)))))))))
	     (case (string-ref str r)
		((#\< #\>)
		 (loop (+fx r 1) (+fx nlen 3)))
		((#\&)
		 (loop (+fx r 1) (+fx nlen 4)))
		((#\")
		 (loop (+fx r 1) (+fx nlen 5)))
		(else
		 (loop (+fx r 1) nlen)))))))

;*---------------------------------------------------------------------*/
;*    html-width ...                                                   */
;*---------------------------------------------------------------------*/
(define (html-width width)
   (if (or (fixnum? width) (string? width))
       width
       (string-append (number->string (inexact->exact (* 100. width))) "%")))
	   
;*---------------------------------------------------------------------*/
;*    do-number ...                                                    */
;*---------------------------------------------------------------------*/
(define (do-number sup cur)
   (if (and (string? sup) (not (=fx (string-length sup) 0)))
       (string-append sup "." cur)
       cur))

;*---------------------------------------------------------------------*/
;*    title-number ::%node ...                                         */
;*---------------------------------------------------------------------*/
(define-generic (title-number obj::%node)
   "")

;*---------------------------------------------------------------------*/
;*    title-number ::%chapter ...                                      */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%chapter)
   (with-access::%chapter obj (number)
      (if (not (number? number))
	  ""
	  (->string (*scribe-chapter-numbering* number)))))

;*---------------------------------------------------------------------*/
;*    title-number ::%section ...                                      */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%section)
   (with-access::%section obj (number parent)
      (cond
	 ((not (number? number))
	  "")
	 ((not parent)
	  (->string (*scribe-section-numbering* number)))
	 (else
	  (do-number (title-number parent)
		     (->string (*scribe-section-numbering* number)))))))

;*---------------------------------------------------------------------*/
;*    title-number ::%subsection ...                                   */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%subsection)
   (with-access::%subsection obj (number parent)
      (cond
	 ((not (number? number))
	  "")
	 ((not parent)
	  (->string (*scribe-subsection-numbering* number)))
	 (else
	  (do-number (title-number parent)
		     (->string (*scribe-subsection-numbering* number)))))))

;*---------------------------------------------------------------------*/
;*    title-number ::%subsubsection ...                                */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%subsubsection)
   (with-access::%subsubsection obj (number parent)
      (cond
	 ((not (number? number))
	  "")
	 ((not parent)
	  (->string (*scribe-subsubsection-numbering* number)))
	 (else
	  (do-number (title-number parent)
		     (->string (*scribe-subsubsection-numbering* number)))))))





   

