/***************************************************************************
                          pdflib.cpp  -  description
                             -------------------
    begin                : Sat Jan 19 2002
    copyright            : (C) 2002 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pdflib.h"
#include "config.h"
#include <qregexp.h>
#include <qdatetime.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <stdlib.h>
#include <math.h>
#ifdef HAVE_LIBZ
#include <zlib.h>
#endif
extern QImage LoadPict(QString fn);
extern bool loadText(QString nam, QString *Buffer);

extern "C" void* Run();

void* Run()
{
	PDFlib *dia = new PDFlib();
	return dia;
}
PDFlib::PDFlib()
{
	Dokument = "";
	Catalog.Outlines = 2;
	Catalog.PageTree = 3;
	Catalog.Dest = 4;
	PageTree.Count = 0;
	PageTree.Kids.clear();
	Outlines.First = 0;
	Outlines.Last = 0;
	Outlines.Count = 0;
	XRef.clear();
	NamedDest.clear();
	NDnam = "LI";
	NDnum = 0;
	ObjCounter = 7;
	Seite.ObjNum = 0;
	Seite.Thumb = 0;
	Seite.XObjects.clear();
	Seite.FObjects.clear();
	Seite.AObjects.clear();
	NeedsStroke = true;
	ResNam = "RE";
	ResCount = 0;
#ifdef HAVE_LIBZ
	CompAvail = true;
#else
	CompAvail = false;
#endif
}

PDFlib::~PDFlib()
{
}

QString PDFlib::FToStr(float c)
{
	QString cc;
	return cc.setNum(c);
}

QString PDFlib::IToStr(int c)
{
	QString cc;
	return cc.setNum(c);
}

void PDFlib::PutDoc(QString in)
{
	Dokument += in;
}

void PDFlib::PutPage(QString in)
{
	Inhalt += in;
}

void PDFlib::StartObj(int nr)
{
	XRef.append(Dokument.length());
	PutDoc(IToStr(nr)+ " 0 obj\n");
}

QString PDFlib::CompressStr(QString *in)
{
	QString out = "";
#ifdef HAVE_LIBZ
	if (CompAvail)
		{
		QByteArray bb(in->length());
		for (uint ax = 0; ax < in->length(); ax++)
			{
			bb[ax] = uchar(QChar(in->at(ax)));
			}
		uLong exlen = uint(bb.size() * 0.001 + 16) + bb.size();
		QByteArray bc(exlen);
		compress2((Byte *)bc.data(), &exlen, (Byte *)bb.data(), uLong(bb.size()), 9);
		for (uint cl = 0; cl < exlen; cl++)
			{
			out += bc[cl];
			}
		}
	else
#endif
		out = *in;
	return out;
}

void PDFlib::PDF_Begin_Doc(ScribusDoc *docu, ScribusView *vie, PDFOpt *opts, SCFonts &AllFonts, QMap<QString,QFont> DocFonts, BookMView* vi)
{
	QString tmp;
	QFileInfo fd;
	int a;
	doc = docu;
	view = vie;
	Bvie = vi;
	Options = opts;
	UsedFonts.clear();
	if (Options->Articles)
		ObjCounter = 7;
	else
		ObjCounter = 6;
	if (Options->Version == 13)
		PutDoc("%PDF-1.3\n");
	if (Options->Version == 14)
		PutDoc("%PDF-1.4\n");
	PutDoc("%"+QString(QChar(199))+QString(QChar(236))+QString(QChar(143))+QString(QChar(162))+"\n");
	StartObj(1);
	PutDoc("<<\n/Type /Catalog\n");
	PutDoc("/Outlines 3 0 R\n");
	PutDoc("/Pages 4 0 R\n");
	PutDoc("/Dests 5 0 R\n");
	if (Options->Articles)
		PutDoc("/Threads 6 0 R\n");
	PutDoc("/ViewerPreferences << /PageDirection ");
	if (Options->Binding == 0)
		PutDoc("/L2R");
	else
		PutDoc("/R2L");
	PutDoc(" >>\n>>\n");
	PutDoc("endobj\n");
	QDate d = QDate::currentDate();
	QString Datum = "D:";
	tmp.sprintf("%4d", d.year());
	tmp.replace(QRegExp(" "), "0");
	Datum += tmp;
	tmp.sprintf("%2d", d.month());
	tmp.replace(QRegExp(" "), "0");
	Datum += tmp;
	tmp.sprintf("%2d", d.day());
	tmp.replace(QRegExp(" "), "0");
	Datum += tmp;
	QTime t = QTime::currentTime();
	tmp = t.toString();
	tmp.replace(QRegExp(":"), "");
	Datum += tmp;
	StartObj(2);
	PutDoc("<<\n/Creator (Scribus "+QString(VERSION)+")\n");
	PutDoc("/Producer (Libpdf for Scribus v0.2)\n");
	PutDoc("/Title ("+doc->DocTitel+")\n");
	PutDoc("/Author ("+doc->DocAutor+")\n");
	PutDoc("/CreationDate ("+Datum+")\n");
	PutDoc("/ModDate ("+Datum+")\n");
	PutDoc(">>\nendobj\n");
	XRef.append(Dokument.length());
	XRef.append(Dokument.length());
	XRef.append(Dokument.length());
	if (Options->Articles)
		XRef.append(Dokument.length());
	QMap<QString,QFont>::Iterator it;
	a = 0;
	for (it = DocFonts.begin(); it != DocFonts.end(); ++it)
		{
		fd = QFileInfo(AllFonts[it.key()]->Datei);
		UsedFonts.insert(it.key(), "/Fo"+IToStr(a));
		QString Encod = AllFonts[it.key()]->FontEnc;
		bool cEnc = false;
		if (AllFonts[it.key()]->HasMetrics)
			{
			if ((fd.extension(false).lower() == "pfb") && (Options->EmbedList.contains(it.key())))
				{
				QString fon = "";
				StartObj(ObjCounter);
				QFile f(AllFonts[it.key()]->Datei);
				QByteArray bb(f.size());
				if (f.open(IO_ReadOnly))
					{
					f.readBlock(bb.data(), f.size());
					f.close();
					}
				uint posi;
				for (posi = 6; posi < bb.size(); posi++)
					{
					if ((int(bb[posi]) == -128) && (int(bb[posi+1]) == 2))
						break;
					fon += bb[posi];
					}
				int len1 = fon.length();
				uint ulen;
				ulen = bb[posi+2] & 0xff;
				ulen |= (bb[posi+3] << 8) & 0xff00;
				ulen |= (bb[posi+4] << 16) & 0xff0000;
				ulen |= (bb[posi+5] << 24) & 0xff000000;
				posi += 6;
				for (uint j = 0; j < ulen; j++)
					{
					fon += bb[posi];
					posi++;
					}
				posi += 6;
				int len2 = fon.length()-len1;
				for (uint j = posi; j < bb.size(); j++)
					{
					if ((int(bb[j]) == -128) && (int(bb[j+1]) == 3))
						break;
					if(bb[j]=='\r')
						fon +="\n";
					else
						fon += bb[j];
					}
				int len3 = fon.length()-len2-len1;
				if ((Options->Compress) && (CompAvail))
					fon = CompressStr(&fon);
				PutDoc("<<\n/Length "+IToStr(fon.length()+1)+"\n");
				PutDoc("/Length1 "+IToStr(len1)+"\n");
				PutDoc("/Length2 "+IToStr(len2)+"\n");
				PutDoc("/Length3 "+IToStr(len3)+"\n");
				if ((Options->Compress) && (CompAvail))
					PutDoc("/Filter /FlateDecode\n");
				PutDoc(">>\nstream\n"+fon+"\nendstream\nendobj\n");
				ObjCounter++;
				}
			if ((fd.extension(false).lower() == "pfa") && (Options->EmbedList.contains(it.key())))
				{
				QString fon = "";
				QString fon2 = "";
				QString tm = "";
				uint value;
				bool ok = true;
				StartObj(ObjCounter);
				loadText(AllFonts[it.key()]->Datei, &fon);
				int len1 = fon.find("eexec")+5;
				fon2 = fon.left(len1)+"\n";
				int len2 = fon.find("0000000000000000000000000");
				if (len2 == -1)
					len2 = fon.length()+1;
				int count = 0;
				for (int xx = len1; xx < len2-1; xx++)
					{
					tm = fon.at(xx);
					if (tm == QChar(13))
						continue;
					if (tm == QChar(10))
						continue;
					xx++;
					count++;
					tm += fon.at(xx);
					value = tm.toUInt(&ok, 16);
					fon2 += QChar(value);
					}
				fon2 += fon.mid(len2);
				if ((Options->Compress) && (CompAvail))
					fon2 = CompressStr(&fon2);
				PutDoc("<<\n/Length "+IToStr(fon2.length()+1)+"\n");
				PutDoc("/Length1 "+IToStr(len1+1)+"\n");
				PutDoc("/Length2 "+IToStr(count)+"\n");
				if (int(fon.length()-len2) == -1)
					PutDoc("/Length3 0\n");
				else
					PutDoc("/Length3 "+IToStr(fon.length()-len2)+"\n");
				if ((Options->Compress) && (CompAvail))
					PutDoc("/Filter /FlateDecode\n");
				PutDoc(">>\nstream\n"+fon2+"\nendstream\nendobj\n");
				ObjCounter++;
				}
			if ((fd.extension(false).lower() == "ttf") && (Options->EmbedList.contains(it.key())))
				{
				QString fon = "";
				StartObj(ObjCounter);
				QFile f(AllFonts[it.key()]->Datei);
				QByteArray bb(f.size());
				if (f.open(IO_ReadOnly))
					{
					f.readBlock(bb.data(), f.size());
					f.close();
					}
				uint posi;
				for (posi = 0; posi < bb.size(); posi++)
					{
					fon += bb[posi];
					}
				int len = fon.length();
				if ((Options->Compress) && (CompAvail))
					fon = CompressStr(&fon);
				PutDoc("<<\n/Length "+IToStr(fon.length()+1)+"\n");
				PutDoc("/Length1 "+IToStr(len)+"\n");
				if ((Options->Compress) && (CompAvail))
					PutDoc("/Filter /FlateDecode\n");
				PutDoc(">>\nstream\n"+fon+"\nendstream\nendobj\n");
				ObjCounter++;
				}
			StartObj(ObjCounter);
			PutDoc("<<\n/Type /FontDescriptor\n");
			PutDoc("/FontName /"+AllFonts[it.key()]->RealName()+"\n");
			PutDoc("/FontBBox [ "+AllFonts[it.key()]->FontBBox+" ]\n");
			PutDoc("/Flags ");
			QFontInfo fo = QFontInfo(it.data());
			int pfl = 0;
			if (AllFonts[it.key()]->IsFixedPitch)
				pfl = pfl ^ 1;
			if (fo.italic())
				pfl = pfl ^ 64;
			if (Encod == "adobe-fontspecific")
				pfl = pfl ^ 4;
			else
				pfl = pfl ^ 32;
			PutDoc(IToStr(pfl)+"\n");
			PutDoc("/Ascent "+AllFonts[it.key()]->Ascent+"\n");
			PutDoc("/Descent "+AllFonts[it.key()]->Descender+"\n");
			PutDoc("/CapHeight "+AllFonts[it.key()]->CapHeight+"\n");
			PutDoc("/ItalicAngle "+AllFonts[it.key()]->ItalicAngle+"\n");
			PutDoc("/StemV "+AllFonts[it.key()]->StdVW+"\n");
			if ((fd.extension(false).lower() == "ttf") && (Options->EmbedList.contains(it.key())))
				PutDoc("/FontFile2 "+IToStr(ObjCounter-1)+" 0 R\n");
			if ((fd.extension(false).lower() == "pfb") && (Options->EmbedList.contains(it.key())))
				PutDoc("/FontFile "+IToStr(ObjCounter-1)+" 0 R\n");
			if ((fd.extension(false).lower() == "pfa") && (Options->EmbedList.contains(it.key())))
				PutDoc("/FontFile "+IToStr(ObjCounter-1)+" 0 R\n");
			PutDoc(">>\nendobj\n");
			ObjCounter++;
			StartObj(ObjCounter);
			PutDoc("[ ");
			for (int ww = 0; ww < 256; ww++)
				{
				PutDoc(IToStr(int(AllFonts[it.key()]->CharWidth[ww]*1000))+" ");
				}
			PutDoc("]\nendobj\n");
			ObjCounter++;
			}
		StartObj(ObjCounter);
		PutDoc("<<\n/Type /Font\n");
		PutDoc("/Subtype ");
		if (fd.extension(false).lower() == "ttf")
			PutDoc("/TrueType\n");
		else
			PutDoc("/Type1\n");
		PutDoc("/Name /Fo"+IToStr(a)+"\n");
		if (AllFonts[it.key()]->HasMetrics)
			PutDoc("/BaseFont /"+AllFonts[it.key()]->RealName()+"\n");
		else
			PutDoc("/BaseFont /Helvetica\n");
		if ((Encod == "iso8859-1") || (Encod == "ascii-0")) // || (Encod == "adobe-fontspecific"))
			PutDoc("/Encoding /WinAnsiEncoding\n");
		if ((Encod == "iso8859-2") || (Encod == "iso8859-15"))
			{
			PutDoc("/Encoding "+IToStr(ObjCounter+1)+" 0 R\n");
			cEnc = true;
			}
		if (AllFonts[it.key()]->HasMetrics)
			{
			PutDoc("/FirstChar 0\n");
			PutDoc("/LastChar 255\n");
			PutDoc("/Widths "+IToStr(ObjCounter-1)+" 0 R\n");
			PutDoc("/FontDescriptor "+IToStr(ObjCounter-2)+" 0 R\n");
			}
		PutDoc(">>\nendobj\n");
		Seite.FObjects["Fo"+IToStr(a)] = ObjCounter;
		ObjCounter++;
		if (cEnc)
			{
			StartObj(ObjCounter);
			ObjCounter++;
			PutDoc("<< /Type /Encoding\n");
			PutDoc("/Differences [\n");
			QString EncVec;
  		QString Epfad = PREL;
  		Epfad += "/share/scribus/"+Encod+".enc";
			loadText(Epfad, &EncVec);
			PutDoc(EncVec);
			PutDoc("]\n>>\nendobj\n");
			}
		a++;
		}
}

void PDFlib::PDF_Begin_Page(Page* pag)
{
	QString tmp;
	ActPage = pag;
	Inhalt = "";
	Seite.AObjects.clear();
	if (Options->Thumbnails)
		{
		QPixmap pm = view->PageToPixmap(ActPage->PageNr, 100);
		QImage img = pm.convertToImage();
		QString im = ImageToTxt(&img);
		if ((Options->Compress) && (CompAvail))
			im = CompressStr(&im);
		StartObj(ObjCounter);
		PutDoc("<<\n/Width "+IToStr(img.width())+"\n");
		PutDoc("/Height "+IToStr(img.height())+"\n");
		PutDoc("/ColorSpace /DeviceRGB\n");
		PutDoc("/BitsPerComponent 8\n");
		PutDoc("/Length "+IToStr(im.length()+1)+"\n");
		if ((Options->Compress) && (CompAvail))
			PutDoc("/Filter /FlateDecode\n");
		PutDoc(">>\nstream\n"+im+"\nendstream\nendobj\n");
		Seite.Thumb = ObjCounter;
		ObjCounter++;
		}
}

void PDFlib::PDF_End_Page()
{
	uint PgNr = ActPage->PageNr;
	StartObj(ObjCounter);
	Seite.ObjNum = ObjCounter;
	ObjCounter++;
	if ((Options->Compress) && (CompAvail))
		Inhalt = CompressStr(&Inhalt);
	PutDoc("<<\n");
	PutDoc("/Length "+IToStr(Inhalt.length()+1)+"\n");
	if ((Options->Compress) && (CompAvail))
		PutDoc("/Filter /FlateDecode\n");
	PutDoc(">>\nstream\n"+Inhalt+"\nendstream\nendobj\n");
	StartObj(ObjCounter);
	PutDoc("<<\n/Type /Page\n");
	PutDoc("/Parent 4 0 R\n");
	PutDoc("/MediaBox [0 0 "+FToStr(doc->PageB)+" "+FToStr(doc->PageH)+"]\n");
	PutDoc("/Contents "+IToStr(Seite.ObjNum)+" 0 R\n");
	if (Options->Thumbnails)
		PutDoc("/Thumb "+IToStr(Seite.Thumb)+" 0 R\n");
	if (Seite.AObjects.count() != 0)
		{
		PutDoc("/Annots [");
		for (uint b = 0; b < Seite.AObjects.count(); b++)
			{
			PutDoc(IToStr(Seite.AObjects[b])+" 0 R ");
			}
		PutDoc("]\n");
		}
	if (Options->PresentMode)
		{
		PutDoc("/Dur "+IToStr(Options->PresentVals[PgNr].AnzeigeLen)+"\n");
		if (Options->PresentVals[PgNr].Effekt != 0)
			{
			PutDoc("/Trans << /Type /Trans\n");
			PutDoc("/D "+IToStr(Options->PresentVals[PgNr].EffektLen)+"\n");
			switch (Options->PresentVals[PgNr].Effekt)
				{
				case 1:
					PutDoc("/S /Blinds\n");
					if (Options->PresentVals[PgNr].Dm == 0)
						PutDoc("/Dm /H\n");
					else
						PutDoc("/Dm /V\n");
					break;
				case 2:
					PutDoc("/S /Box\n");
					if (Options->PresentVals[PgNr].M == 0)
						PutDoc("/M /I\n");
					else
						PutDoc("/M /O\n");
					break;
				case 3:
					PutDoc("/S /Dissolve\n");
					break;
				case 4:
					PutDoc("/S /Glitter\n");
					PutDoc("/Di "+IToStr(Options->PresentVals[PgNr].Di)+"\n");
					break;
				case 5:
					PutDoc("/S /Split\n");
					if (Options->PresentVals[PgNr].Dm == 0)
						PutDoc("/Dm /H\n");
					else
						PutDoc("/Dm /V\n");
					if (Options->PresentVals[PgNr].M == 0)
						PutDoc("/M /I\n");
					else
						PutDoc("/M /O\n");
					break;
				case 6:
					PutDoc("/S /Wipe\n");
					PutDoc("/Di "+IToStr(Options->PresentVals[PgNr].Di)+"\n");
					break;
				}
			PutDoc(">>\n");
			}
		}
	PutDoc(">>\nendobj\n");
	PageTree.Count++;
	PageTree.Kids.append(ObjCounter);
	ObjCounter++;
}

void PDFlib::PDF_ProcessPage(Page* pag, uint PNr)
{
	QString tmp;
	CMYKColor tmpC;
	QPoint np;
	ActPage = pag;
	int h, s, v, k;
	PageItem* ite;
	struct Pti *hl;
	for (uint a = 0; a < ActPage->Items.count(); a++)
		{
		PutPage("q\n");
		NeedsStroke = true;
		ite = ActPage->Items.at(a);
		if (ite->isBookmark)
			{
			PDF_Bookmark(ite->BMnr, doc->PageH - ite->Ypos);
			}
		if (!ite->isPrintable)
			continue;
		if (ite->Pcolor != "None")
			{
			tmpC = doc->PageColors[ite->Pcolor];
			tmpC.applyGCR();
			tmpC.getCMYK(&h, &s, &v, &k);
			h = h * ite->Shade / 100;
			s = s * ite->Shade / 100;
			v = v * ite->Shade / 100;
			k = k * ite->Shade / 100;
			PutPage(FToStr(h / 255.0)+" "+FToStr(s / 255.0)+" "+FToStr(v / 255.0)+" "+FToStr(k / 255.0)+" k\n");
			}
		if (ite->Pcolor2 != "None")
			{
			tmpC = doc->PageColors[ite->Pcolor2];
			tmpC.applyGCR();
			tmpC.getCMYK(&h, &s, &v, &k);
			h = h * ite->Shade2 / 100;
			s = s * ite->Shade2 / 100;
			v = v * ite->Shade2 / 100;
			k = k * ite->Shade2 / 100;
			PutPage(FToStr(h / 255.0)+" "+FToStr(s / 255.0)+" "+FToStr(v / 255.0)+" "+FToStr(k / 255.0)+" K\n");
			}
		Inhalt += IToStr(QMAX(ite->Pwidth, 1))+" w\n";
		QString Dt = IToStr(QMAX(ite->Pwidth, 1));
		QString Da = IToStr(3*QMAX(ite->Pwidth, 1));
		switch (ite->PLineArt)
			{
			case Qt::SolidLine:
				PutPage("[] 0 d\n");
				break;
			case Qt::DashLine:
				PutPage("["+Da+" "+Dt+"] 0 d\n");
				break;
			case Qt::DotLine:
				PutPage("["+Dt+"] 0 d\n");
				break;
			case Qt::DashDotLine:
				PutPage("["+Da+" "+Dt+" "+Dt+" "+Dt+"] 0 d\n");
				break;
			case Qt::DashDotDotLine:
				PutPage("["+Da+" "+Dt+" "+Dt+" "+Dt+" "+Dt+" "+Dt+"] 0 d\n");
				break;
			default:
				PutPage("[] 0 d\n");
				break;
			}
		switch (ite->PLineEnd)
			{
			case Qt::FlatCap:
				PutPage("0 J\n");
				break;
			case Qt::SquareCap:
				PutPage("2 J\n");
				break;
			case Qt::RoundCap:
				PutPage("1 J\n");
				break;
			default:
				PutPage("0 J\n");
				break;
			}
		switch (ite->PLineJoin)
			{
			case Qt::MiterJoin:
				PutPage("0 j\n");
				break;
			case Qt::BevelJoin:
				PutPage("2 j\n");
				break;
			case Qt::RoundJoin:
				PutPage("1 j\n");
				break;
			default:
				PutPage("0 j\n");
				break;
			}
		PutPage("1 0 0 1 "+FToStr(ite->Xpos)+" "+FToStr(doc->PageH - ite->Ypos)+" cm\n");
		if (ite->Rot != 0)
			{
			float sr = sin(-ite->Rot* 3.1415927 / 180.0);
			float cr = cos(-ite->Rot* 3.1415927 / 180.0);
			if ((cr * cr) < 0.001)
				cr = 0;
			if ((sr * sr) < 0.001)
				sr = 0;
			PutPage(FToStr(cr)+" "+FToStr(sr)+" "+FToStr(-sr)+" "+FToStr(cr)+" 0 0 cm\n");
			}
		switch (ite->PType)
			{
			case 1:
				PDF_circle((ite->Width / 2.0),(-ite->Height / 2.0));
				break;
			case 2:
				if ((ite->flippedH % 2) != 0)
					PutPage("-1 0 0 1 "+FToStr(ite->Width)+" 0 cm\n");
				if ((ite->flippedV % 2) != 0)
					PutPage("1 0 0 -1 0 "+FToStr(-ite->Height)+" cm\n");
				if (ite->Pcolor != "None")
					{
					if ((ite->FrameType == 2) && (!ite->ClipEdited))
						PDF_roundRect(ite->Width, -ite->Height, ite->RadRect);
					else
						{	
						np = ite->Clip.point(0);
						PutPage(IToStr(np.x())+" "+IToStr(-np.y())+" m\n");
						for (uint d = 1; d < ite->Clip.count(); d++)
							{
							np = ite->Clip.point(d);
							PutPage(IToStr(np.x())+" "+IToStr(-np.y())+" l\n");
							}
						}
					PutPage("h\nf\n");
					}
				if ((ite->FrameType == 2) && (!ite->ClipEdited))
					PDF_roundRect(ite->Width, -ite->Height, ite->RadRect);
				else
					{	
					np = ite->Clip.point(0);
					PutPage(IToStr(np.x())+" "+IToStr(-np.y())+" m\n");
					for (uint d = 1; d < ite->Clip.count(); d++)
						{
						np = ite->Clip.point(d);
						PutPage(IToStr(np.x())+" "+IToStr(-np.y())+" l\n");
						}
					}
				PutPage("h\nW\nn\n");
				if ((ite->PicAvail) && (ite->Pfile != ""))
					{					
					PDF_Image(ite->Pfile, ite->LocalScX, ite->LocalScY, ite->LocalX, -ite->LocalY);
					}
				NeedsStroke = false;
				break;
			case 3:
				if (ite->RadRect != 0)
					PDF_roundRect(ite->Width, -ite->Height, ite->RadRect);
				else
					PutPage("0 0 "+FToStr(ite->Width)+" "+FToStr(-ite->Height)+" re\n");
				break;
			case 4:
				NeedsStroke = false;
				if (ite->isAnnotation)
					{
					QString bm = "";
					QString cc;
					for (uint d = 0; d < ite->Ptext.count(); d++)
						{
						cc = ite->Ptext.at(d)->ch;
						if ((cc == "(") || (cc == ")") || (cc == "\\"))
							bm += "\\";
						bm += cc;
						}
					PDF_Annotation(ite->AnType, ite->AnZiel, ite->AnAction, bm, ite->Xpos, doc->PageH - ite->Ypos, ite->Xpos+ite->Width, doc->PageH-ite->Ypos-ite->Height);
					break;
					}
				if ((ite->flippedH % 2) != 0)
					PutPage("-1 0 0 1 "+FToStr(ite->Width)+" 0 cm\n");
				if ((ite->flippedV % 2) != 0)
					PutPage("1 0 0 -1 0 "+FToStr(-ite->Height)+" cm\n");
				if (ite->Pcolor != "None")
					{
					if ((ite->FrameType == 2) && (!ite->ClipEdited))
						PDF_roundRect(ite->Width, -ite->Height, ite->RadRect);
					else
						{	
						np = ite->Clip.point(0);
						PutPage(IToStr(np.x())+" "+IToStr(-np.y())+" m\n");
						for (uint d = 1; d < ite->Clip.count(); d++)
							{
							np = ite->Clip.point(d);
							PutPage(IToStr(np.x())+" "+IToStr(-np.y())+" l\n");
							}
						}
					PutPage("h\nf\n");
					}
				PutPage("BT\n0 Tr\n");
				for (uint d = 0; d < ite->MaxChars; d++)
					{
					hl = ite->Ptext.at(d);
					if ((hl->ch == QChar(13)) || (hl->ch == QChar(10)))
						continue;
					if (hl->yp == 0)
						break;
					int	tsz = hl->csize;
					QString chx = hl->ch;
					if (hl->ch == QChar(30))
						{
						uint zae = 0;
						while (ite->Ptext.at(d+zae)->ch == QChar(30))
							{
							zae++;
							if (d+zae == ite->MaxChars)
								break;
							}
						QString out="%1";
						chx = out.arg(PNr+1, zae).right(zae).left(1);
						}
					if ((hl->cstyle & 127) == 0)
						PutPage(UsedFonts[hl->cfont]+" "+IToStr(hl->csize)+" Tf\n");
					if (hl->cstyle & 64)
						{
						if (chx.upper() != chx)
							{
							tsz = hl->csize * doc->VKapit / 100;
							chx = chx.upper();
							}
						}
					if (hl->cstyle & 1)
						tsz = hl->csize * doc->VHochSc / 100;
					if (hl->cstyle & 2)
						tsz = hl->csize * doc->VHochSc / 100;
					if (!(hl->cstyle & 4))
						{
						if ((hl->cstyle & 127) != 0)
							PutPage(UsedFonts[hl->cfont]+" "+IToStr(tsz)+" Tf\n");
						}
					if (hl->ccolor != "None")
						{
						tmpC = doc->PageColors[hl->ccolor];
						tmpC.applyGCR();
						tmpC.getCMYK(&h, &s, &v, &k);
						h = h * hl->cshade / 100;
						s = s * hl->cshade / 100;
						v = v * hl->cshade / 100;
						k = k * hl->cshade / 100;
						PutPage(FToStr(h / 255.0)+" "+FToStr(s / 255.0)+" "+FToStr(v / 255.0)+" "+FToStr(k / 255.0)+" k\n");
						PutPage(FToStr(h / 255.0)+" "+FToStr(s / 255.0)+" "+FToStr(v / 255.0)+" "+FToStr(k / 255.0)+" K\n");
						}
					if ((chx == "(") || (chx == ")") || (chx == "\\"))
						chx.prepend("\\");
					if (hl->cstyle & 32)
						{
						PutPage("2 Tr\n");
						PutPage("1 0 0 1 "+FToStr(hl->xp)+" "+FToStr(-hl->yp)+" Tm\n");
						PutPage("("+chx.local8Bit()+") Tj\n");
						PutPage("0 Tr\n");
						}
					else
						{
						PutPage("1 0 0 1 "+FToStr(hl->xp)+" "+FToStr(-hl->yp)+" Tm\n");
						PutPage("("+chx.local8Bit()+") Tj\n");
						}
/*					if (hl->cstyle & 8)
						{
						p->PS_underline(chxc, hl->xp, -hl->yp);
						}
					if (hl->cstyle & 16)
						{
						p->PS_strikeout(chxc, hl->xp, -hl->yp + tsz / 3);
						}  */
					if ((hl->cstyle & 128) && (ite->Ptext.at(QMIN(d+1, ite->Ptext.count()-1))->yp != hl->yp))
						{
						PutPage("(-) Tj\n");
						}
					}
				PutPage("ET\n");
				break;
			case 5:
				PutPage("0 0 m\n");
				PutPage(FToStr(ite->Width)+" "+FToStr(-ite->Height)+" l\n");
				PutPage("S\n");
				NeedsStroke = false;
			}
		if (NeedsStroke)
			{
			if (ite->Pcolor == "None")
				PutPage("S\n");
			else
				{
				if (ite->Pcolor == "None")
					PutPage("f\n");
				else
					PutPage("B\n");
				}
			}
		PutPage("Q\n");
		}
}

void PDFlib::PDF_Annotation(int Typ, int Ziel, QString Act, QString text, float x, float y, float x2, float y2)
{
	struct Dest de;
	StartObj(ObjCounter);
	Seite.AObjects.append(ObjCounter);
	ObjCounter++;
	PutDoc("<<\n/Type /Annot\n");
	switch (Typ)
		{
		case 0:
			PutDoc("/Subtype /Text\n");
			PutDoc("/Contents ("+text+")\n");
			break;
		case 1:
			PutDoc("/Subtype /Link\n");
			PutDoc("/Dest /"+NDnam+IToStr(NDnum)+"\n");
			de.Name = NDnam+IToStr(NDnum);
			de.Seite = Ziel;
			de.Act = Act;
			NamedDest.append(de);
			NDnum++;
			break;
		}
	PutDoc("/Border [ 0 0 0 ]\n");
	PutDoc("/Rect [ "+FToStr(x)+" "+FToStr(y)+" "+FToStr(x2)+" "+FToStr(y2)+" ]\n");
	PutDoc(">>\nendobj\n");
}

void PDFlib::PDF_Bookmark(int nr, float ypos)
{
	Bvie->SetAction(nr, "/XYZ 0 "+FToStr(ypos)+" 0]");
}

void PDFlib::PDF_circle(float x, float y)
{
	float rx = x;
	float ry = y;
	Inhalt += FToStr(x+rx)+" "+FToStr(y)+" m\n";
	Inhalt += FToStr(x + rx)+" "+FToStr(y + ry*0.552284749)+" ";
	Inhalt += FToStr(x + rx*0.552284749)+" "+FToStr(y + ry)+" ";
	Inhalt += FToStr(x)+" "+FToStr(y + ry)+" c\n";
	Inhalt += FToStr(x - rx*0.552284749)+" "+FToStr(y + ry)+" ";
	Inhalt += "0 "+FToStr(y + ry*0.552284749)+" ";
	Inhalt += "0 "+FToStr(y)+" c\n";
	Inhalt += "0 "+FToStr(y - ry*0.552284749)+" ";
	Inhalt += FToStr(x - rx*0.552284749)+" 0 ";
	Inhalt += FToStr(x)+" 0 c\n";
	Inhalt += FToStr(x + rx*0.552284749)+" 0 ";
	Inhalt += FToStr(x + rx)+" "+FToStr(y - ry*0.552284749)+" ";
	Inhalt += FToStr(x + rx)+" "+FToStr(y)+" c\n";
}

void PDFlib::PDF_roundRect(float b, float h, float r)
{
	Inhalt += FToStr(r)+" 0 m\n";
	Inhalt += FToStr(b-r)+" 0 l\n";
	Inhalt += FToStr(b-r + r*0.552284749)+" 0 ";
	Inhalt += FToStr(b)+" "+FToStr(-r*0.552284749)+" ";
	Inhalt += FToStr(b)+" "+FToStr(-r)+" c\n";
	Inhalt += FToStr(b)+" "+FToStr(h+r)+" l\n";
	Inhalt += FToStr(b)+" "+FToStr(h+r -r*0.552284749)+" ";
	Inhalt += FToStr(b-r + r*0.552284749)+" "+FToStr(h)+" ";
	Inhalt += FToStr(b-r)+" "+FToStr(h)+" c\n";
	Inhalt += FToStr(r)+" "+FToStr(h)+" l\n";
	Inhalt += FToStr(r*0.552284749)+" "+FToStr(h)+" ";
	Inhalt += "0 "+FToStr(h+r -r*0.552284749)+" ";
	Inhalt += "0 "+FToStr(h+r)+" c\n";
	Inhalt += "0 "+FToStr(-r)+" l\n";
	Inhalt += "0 "+FToStr(-r*0.552284749)+" ";
	Inhalt += FToStr(r*0.552284749)+" 0 ";
	Inhalt += FToStr(r)+" 0 c\n";
}

QString PDFlib::ImageToTxt(QImage *im)
{
	int h = im->height();
	int w = im->width();
	QString ImgStr = "";
	for( int yi=0; yi < h; yi++ )
		{
		QRgb * s = (QRgb*)(im->scanLine( yi ));
		for( int xi=0; xi < w; xi++ )
			{
			QRgb r=*s++;
			unsigned char u=qRed(r);
			ImgStr += u;
			u=qGreen(r);
			ImgStr += u;
			u=qBlue(r);
			ImgStr += u;
			}
		}
	return ImgStr;
}

QString PDFlib::MaskToTxt(QImage *im)
{
	int h = im->height();
	int w = im->width();
  int w2;
  w2 = w / 8;
  if ((w % 8) != 0)
  	w2++;
	QString ImgStr = "";
	for( int yi=0; yi < h; yi++ )
		{
		uchar * s = im->scanLine( yi );
		for( int xi=0; xi < w2; xi++ )
			{
			unsigned char u = *(s+xi);
			ImgStr += ~u;
			}
		}
	return ImgStr;
}

void PDFlib::PDF_Image(QString fn, float sx, float sy, float x, float y)
{
	QFileInfo fi = QFileInfo(fn);
	QString ext = fi.extension(false).lower();
	QImage img;
	QString im, tmp, dummy, cmd1, cmd2, BBox;
	QChar tc;
	bool found = false;
	int ret = -1;
	float x2, y2, b, h, ax, ay, a2, a1;
	x2 = 0;
	float aufl = Options->Resolution / 72.0;
	if (ext == "eps")
		{
		QFile f(fn);
		if (f.open(IO_ReadOnly))
			{
			QTextStream ts(&f);
			while (!ts.atEnd())
				{
				tc = ' ';
				tmp = "";
				while ((tc != '\n') && (tc != '\r'))
					{
					ts >> tc;
					if ((tc != '\n') && (tc != '\r'))
						tmp += tc;
					}
				if (tmp.startsWith("%%BoundingBox"))
					{
					found = true;
					BBox = tmp;
					}
				if (tmp.startsWith("%%EndComments"))
					break;
				}	
			f.close();
			if (found)
				{
				QTextStream ts2(&BBox, IO_ReadOnly);
				ts2 >> dummy >> x2 >> y2 >> b >> h;
				x2 = x2 * aufl;
				y2 = y2 * aufl;
				b = b * aufl;
				h = h * aufl;
				cmd1 = "gs -q -dNOPAUSE -sDEVICE=png16m -r"+IToStr(Options->Resolution)+" -sOutputFile=/tmp/sc.png -g";
				cmd2 = " -c showpage -c quit";
				ret = system(cmd1 + tmp.setNum(qRound(b)) + "x" + tmp.setNum(qRound(h)) + " " + fn + cmd2);
				if (ret == 0)
					{
					QImage image;
					image.load("/tmp/sc.png");
  				image = image.convertDepth(32);
					img = image.copy(x2, 0, b-x2, h-y2);
					system("rm -f /tmp/sc.png");
					}
				}
			}
		if (Options->RecalcPic)
			{
			float afl = QMIN(Options->PicRes, Options->Resolution);
			a2 = Options->Resolution / afl / sx;
			a1 = Options->Resolution / afl / sy;
			if (a2 > 1.0)
				ax = img.width() / a2;
			else
				ax = img.width();
			if (a1 > 1.0)
				ay = img.height() / a1;
			else
				ay = img.height();
			img = img.smoothScale(ax, ay);
  		img = img.convertDepth(32);
			sx = sx * a2;
			sy = sy * a1;
			}
		im = ImageToTxt(&img);
		}
	else
		{
		if (ext == "jpg")
			{
			img = LoadPict(fn);
			loadText(fn, &im);
			}
		else
			{
			img = LoadPict(fn);
			if (Options->RecalcPic)
				{
				float afl = QMIN(Options->PicRes, Options->Resolution);
				a2 = (72.0 / sx) / afl;
				a1 = (72.0 / sy) / afl;
				if (a2 > 1.0)
					ax = img.width() / a2;
				else
					ax = img.width();
				if (a1 > 1.0)
					ay = img.height() / a1;
				else
					ay = img.height();
				img = img.smoothScale(ax, ay);
  			img = img.convertDepth(32);
				sx = sx * a2;
				sy = sy * a1;
				}
			im = ImageToTxt(&img);
			}
		aufl = 1;
		}
	sx = sx * (1.0 / aufl);
	sy = sy * (1.0 / aufl);
  if (img.hasAlphaBuffer())
 		{
		QImage iMask = img.createAlphaMask();
		QString im2 = MaskToTxt(&iMask);
		StartObj(ObjCounter);
		ObjCounter++;
		if ((Options->Compress) && (CompAvail))
			im2 = CompressStr(&im2);
		PutDoc("<<\n/Type /XObject\n");
		PutDoc("/Subtype /Image\n");
		PutDoc("/Width "+IToStr(iMask.width())+"\n");
		PutDoc("/Height "+IToStr(iMask.height())+"\n");
		PutDoc("/ImageMask true\n");
		PutDoc("/BitsPerComponent 1\n");
		PutDoc("/Length "+IToStr(im2.length())+"\n");
		if ((Options->Compress) && (CompAvail))
			PutDoc("/Filter /FlateDecode\n");
		PutDoc(">>\nstream\n"+im2+"\nendstream\nendobj\n");
		Seite.XObjects[ResNam+IToStr(ResCount)] = ObjCounter-1;
		ResCount++;
		}
	StartObj(ObjCounter);
	ObjCounter++;
	if ((Options->Compress) && (ext != "jpg") && (CompAvail))
		im = CompressStr(&im);
	PutDoc("<<\n/Type /XObject\n");
	PutDoc("/Subtype /Image\n");
	PutDoc("/Width "+IToStr(img.width())+"\n");
	PutDoc("/Height "+IToStr(img.height())+"\n");
	if ((img.isGrayscale()) && (ext == "jpg"))
		PutDoc("/ColorSpace /DeviceGray\n");
	else
		PutDoc("/ColorSpace /DeviceRGB\n");
	PutDoc("/BitsPerComponent 8\n");
	PutDoc("/Length "+IToStr(im.length())+"\n");
  if (img.hasAlphaBuffer())
		PutDoc("/Mask "+IToStr(ObjCounter-2)+" 0 R\n");
	if (ext == "jpg")
		PutDoc("/Filter /DCTDecode\n");
	else
		{
		if ((Options->Compress) && (CompAvail))
			PutDoc("/Filter /FlateDecode\n");
		}
	PutDoc(">>\nstream\n"+im+"\nendstream\nendobj\n");
	Seite.XObjects[ResNam+IToStr(ResCount)] = ObjCounter-1;
	Inhalt += IToStr(img.width()*sx)+" 0 0 "+IToStr(img.height()*sy)+" "+IToStr(x*sx)+" "+IToStr((-img.height()+y)*sy)+" cm\n";
	Inhalt += "/"+ResNam+IToStr(ResCount)+" Do\n";
	ResCount++;
	return;
}

QString PDFlib::PDF_End_Doc()
{
	QString tmp;
	uint StX;
	int Basis;
	BookMItem* ip;
	QListViewItem* pp;
	QString Inhal = "";
	QMap<int,QString> Inha;
	Inha.clear();
	int Bmc = 0;
	if ((Bvie->childCount() != 0) && (Options->Bookmarks))
		{
		Basis = ObjCounter - 1;
		Outlines.Count = Bvie->childCount();
		ip = (BookMItem*)Bvie->firstChild();
		pp = Bvie->firstChild();
		Outlines.First = ip->ItemNr+Basis;
		while (pp)
			{
			if (!pp->nextSibling())
				{
				ip = (BookMItem*)pp;
				Outlines.Last = ip->ItemNr+Basis;
				break;
				}
			pp = pp->nextSibling();
			}
		QListViewItemIterator it(Bvie);
		for ( ; it.current(); ++it)
			{
			ip = (BookMItem*)it.current();
			Inhal = "";
			Bmc++;
			Inhal += IToStr(ip->ItemNr+Basis)+ " 0 obj\n";
			Inhal += "<<\n/Title ("+ip->Titel+")\n";
			if (ip->Pare == 0)
				Inhal += "/Parent 3 0 R\n";
			else
				Inhal += "/Parent "+IToStr(ip->Pare+Basis)+" 0 R\n";
			if (ip->Prev != 0)
				Inhal += "/Prev "+IToStr(ip->Prev+Basis)+" 0 R\n";
			if (ip->Next != 0)
				Inhal += "/Next "+IToStr(ip->Next+Basis)+" 0 R\n";
			if (ip->First != 0)
				Inhal += "/First "+IToStr(ip->First+Basis)+" 0 R\n";
			if (ip->Last != 0)
				Inhal += "/Last "+IToStr(ip->Last+Basis)+" 0 R\n";
			if (ip->firstChild())
				Inhal += "/Count -"+IToStr(ip->childCount())+"\n";
			Inhal += "/Dest ["+IToStr(PageTree.Kids[ip->Seite])+" 0 R "+ip->Action+"\n";
			Inhal += ">>\nendobj\n";
			Inha[ip->ItemNr] = Inhal;
			}
		for (int b = 1; b < Bmc+1; b++)
			{
			XRef.append(Dokument.length());
			Dokument += Inha[b];
			ObjCounter++;
			}
		}
	StartObj(ObjCounter);
	PutDoc("<< /ProcSet [/PDF /Text /ImageB /ImageC /ImageI]\n");
	if (Seite.XObjects.count() != 0)
		{
		PutDoc("/XObject <<\n");
		QMap<QString,int>::Iterator it;
		for (it = Seite.XObjects.begin(); it != Seite.XObjects.end(); ++it)
			{
			PutDoc("/"+it.key()+" "+IToStr(it.data())+" 0 R\n");
			}
		PutDoc(">>\n");
		}
	if (Seite.FObjects.count() != 0)
		{
		PutDoc("/Font << \n");
		QMap<QString,int>::Iterator it2;
		for (it2 = Seite.FObjects.begin(); it2 != Seite.FObjects.end(); ++it2)
			{
			PutDoc("/"+it2.key()+" "+IToStr(it2.data())+" 0 R\n");
			}
		PutDoc(">>\n");
		}
	PutDoc(">>\nendobj\n");
	ObjCounter++;
	XRef[2] = Dokument.length();
	PutDoc("3 0 obj\n");
	PutDoc("<<\n/Type /Outlines\n");
	PutDoc("/Count "+IToStr(Outlines.Count)+"\n");
	if ((Bvie->childCount() != 0) && (Options->Bookmarks))
		{
		PutDoc("/First "+IToStr(Outlines.First)+" 0 R\n");
		PutDoc("/Last "+IToStr(Outlines.Last)+" 0 R\n");
		}
	PutDoc(">>\nendobj\n");
	XRef[3] = Dokument.length();
	PutDoc("4 0 obj\n");
	PutDoc("<<\n/Type /Pages\n");
	PutDoc("/Kids [");
	for (uint b = 0; b < PageTree.Kids.count(); b++)
		{
		PutDoc(IToStr(PageTree.Kids[b])+" 0 R ");
		}
	PutDoc("]\n");
	PutDoc("/Count "+IToStr(PageTree.Count)+"\n");
	PutDoc("/Resources "+IToStr(ObjCounter-1)+" 0 R\n");
	PutDoc(">>\nendobj\n");
	XRef[4] = Dokument.length();
	PutDoc("5 0 obj\n");
	PutDoc("<<\n");
	if (NamedDest.count() != 0)
		{
		QValueList<Dest>::Iterator vt;
		for (vt = NamedDest.begin(); vt != NamedDest.end(); ++vt)
			{
			PutDoc("/"+(*vt).Name+" ["+IToStr(PageTree.Kids[(*vt).Seite])+" 0 R /XYZ "+(*vt).Act+"]\n");
			}
		}
	PutDoc(">>\nendobj\n");
	if (Options->Articles)
		{
		Threads.clear();
		for (uint pgs = 0; pgs < view->Pages.count(); pgs++)
			{
			for (uint ele = 0; ele < view->Pages.at(pgs)->Items.count(); ele++)
				{
				PageItem* tel = view->Pages.at(pgs)->Items.at(ele);
				if ((tel->PType == 4) && (tel->BackBox == 0) && (tel->NextBox != 0) && (!tel->Redrawn))
					{
					StartObj(ObjCounter);
					Threads.append(ObjCounter);
					ObjCounter++;
					PutDoc("<< /Type /Thread\n");
					PutDoc("   /F "+IToStr(ObjCounter)+" 0 R\n");
					PutDoc(">>\nendobj\n");
					Beads.clear();
					struct Bead bd;
					int fir = ObjCounter;
					int ccb = ObjCounter;
					bd.Parent = ObjCounter-1;
					while (tel->NextBox != 0)
						{
						bd.Next = ccb + 1;
						bd.Prev = ccb - 1;
						ccb++;
						bd.Page = PageTree.Kids[pgs];
						bd.Recht = QRect(tel->Xpos, doc->PageH - tel->Ypos, tel->Width, tel->Height);
						tel->Redrawn = true;
						tel = tel->NextBox;
						Beads.append(bd);
						}
					bd.Next = ccb + 1;
					bd.Prev = ccb - 1;
					bd.Page = PageTree.Kids[pgs];
					bd.Recht = QRect(tel->Xpos, doc->PageH - tel->Ypos, tel->Width, tel->Height);
					tel->Redrawn = true;
					Beads.append(bd);
					Beads[0].Prev = fir + Beads.count()-1;
					Beads[Beads.count()-1].Next = fir;
					for (uint beac = 0; beac < Beads.count(); beac++)
						{
						StartObj(ObjCounter);	
						ObjCounter++;
						PutDoc("<< /Type /Bead\n");
						PutDoc("   /T "+IToStr(Beads[beac].Parent)+" 0 R\n");
						PutDoc("   /N "+IToStr(Beads[beac].Next)+" 0 R\n");
						PutDoc("   /V "+IToStr(Beads[beac].Prev)+" 0 R\n");
						PutDoc("   /P "+IToStr(Beads[beac].Page)+" 0 R\n");
						PutDoc("   /R [ "+IToStr(Beads[beac].Recht.x())+" "+IToStr(Beads[beac].Recht.y())+" ");
						PutDoc(IToStr(Beads[beac].Recht.bottomRight().x())+" "+IToStr(Beads[beac].Recht.y()-Beads[beac].Recht.height())+" ]\n");
						PutDoc(">>\nendobj\n");
						}
					}
				}
			}
		for (uint pgs = 0; pgs < view->Pages.count(); pgs++)
			{
			for (uint ele = 0; ele < view->Pages.at(pgs)->Items.count(); ele++)
				{
				view->Pages.at(pgs)->Items.at(ele)->Redrawn = false;
				}
			}
		XRef[5] = Dokument.length();
		PutDoc("6 0 obj\n");
		PutDoc("[");
		for (uint th = 0; th < Threads.count(); th++)
			{
			PutDoc(IToStr(Threads[th])+" 0 R ");
			}
		PutDoc("]\n");	
		PutDoc("endobj\n");
		}
	StX = Dokument.length();
	PutDoc("xref\n");
	PutDoc("0 "+IToStr(ObjCounter)+"\n");
	PutDoc("0000000000 65535 f \n");
	for (uint a = 0; a < XRef.count(); a++)
		{
		tmp.sprintf("%10d", XRef[a]);
		tmp.replace(QRegExp(" "), "0");
		PutDoc(tmp+" 00000 n \n");
		}
	PutDoc("trailer\n<<\n/Size "+IToStr(XRef.count()+1)+"\n");
	PutDoc("/Root 1 0 R\n/Info 2 0 R\n>>\nstartxref\n");
	PutDoc(IToStr(StX)+"\n%%EOF\n");
	return Dokument;
}

