#!/usr/bin/env perl
#
# graywin.pl
#
#	adapted from SDL-1.2.x/test/graywin.c
#

use SDL::App;
use SDL::Rect;
use SDL::Event;

my %options;

for ( 0 .. @ARGV )
{
	$options{$_} = $ARGV[$_ + 1] || 1;
}

$options{-flags} = SDL_SWSURFACE;
$options{-flags} |= SDL_HWPALETTE if ( $options{-hw} );
$options{-flags} |= SDL_FULLSCREEN if ( $options{-fullscreen} );

$options{-title} = 'graywin.pl';

$options{-width} ||= 640;
$options{-height} ||= 480;
$options{-depth} ||= $options{-bpp} || 24;

my $app = new SDL::App %options;

sub DrawBox {
	my ($x,$y) = @_;

	my ($w, $h) = ( int(rand(640)), int(rand(480)) );
	
	my $rect = new SDL::Rect -width => $w, -height => $h, 
			-x => ($x - int($w/2)), -y => ($y - int($h/2));
	
	my $color = SDL::MapRGB($app->{-surface},rand(256),rand(256),rand(256));

	$app->fill($rect,$color);
	$app->update($rect);
};

my $event = new SDL::Event;

my $done = 0;

my %events = ( 
	SDL_MOUSEBUTTONDOWN() => sub { DrawBox($event->button_x(),$event->button_y()); },
	SDL_KEYDOWN() => sub { 
		$app->warp($options{-width}/2,$options{-height}/2) 
			if ($event->key_sym() == SDLK_SPACE);
		$app->fullscreen()
			if ($event->key_sym() == SDLK_RETURN);
		$done = 1 if ($event->key_sym() == SDLK_ESCAPE);	
		},
	SDL_QUIT() => sub { $done = 1; }
);

while (!$done && $event->wait())
{
	if ( $events{$event->type()}) {
		&{$events{$event->type()}};
	}
};


