/*
 *                          Music File Referance List IO
 */
#ifndef MUSICLISTIO_H
#define MUSICLISTIO_H

#include <sys/types.h>
#include "sound.h"


/*
 *	Music file referance flags:
 */
#define SAR_MUSIC_REF_FLAGS_REPEAT	(1 << 1)
#define SAR_MUSIC_REF_FLAGS_FADE_IN	(1 << 2)
#define SAR_MUSIC_REF_FLAGS_FADE_OUT	(1 << 3)

/*
 *	Music file referance structure:
 */
typedef struct {

	char *name;		/* Referance name. */
	char *filename;

	unsigned int flags;	/* Any of SAR_MUSIC_REF_FLAGS_*. */

	/* Referance name of next music to be played if this one does
	 * not repeat (NULL for none).
	 */
	char *next_name;

} sar_music_ref_struct;


extern sar_music_ref_struct *SARMusicMatch(
	sar_music_ref_struct **ml, int total,
	int ref_code
);

extern void SARMusicListDeleteAll(
        sar_music_ref_struct ***ml, int *total
);
extern int SARMusicListLoadFromFile(
        const char *filename,
	sar_music_ref_struct ***ml, int *total
);

#endif	/* MUSICLISTIO_H */
