#include <stdio.h>
#include <sys/types.h>
#include "../include/os.h"

#ifdef __MSW__
# include <windows.h>
#else
# include <unistd.h>
#endif

#include <GL/gl.h>

#include "../include/string.h"

#include "gw.h"
#include "menu.h"
#include "sar.h"


int SARLoadProgressCB(
	void *ptr, long file_pos, long file_size
);


/*
 *	SAR load progress callback.
 *
 *	Returns non-zero to indicate abort load.
 *
 *	Given input ptr must be of type sar_progress_cb_struct.
 */
int SARSceneLoadProgressCB(
	void *ptr,
	long file_pos, long file_size
)
{
	int n;
	sar_core_struct *core_ptr;
	sar_menu_struct *menu_ptr;
	gw_display_struct *display;
	sar_progress_cb_struct *cb_data = (sar_progress_cb_struct *)ptr;


	if(cb_data == NULL)
	    return(0);

	core_ptr = cb_data->core_ptr;
	if(core_ptr == NULL)
	    return(0);

	display = core_ptr->display;
	if(display == NULL)
	    return(0);

	/* Get pointer to load simulation progress menu. */
	n = SARMatchMenuByName(
	    core_ptr,
	    SAR_MENU_NAME_LOADING_SIMULATION
	);
	menu_ptr = ((n < 0) ? NULL : core_ptr->menu[n]);
	if(menu_ptr == NULL)
	    return(0);

	if(file_size > 0)
	{
	    SARMenuSetProgressSimple(
		display,
		menu_ptr,
		(double)file_pos / (double)file_size,
		1
	    );
	    GWSwapBuffer(display);
	}

	return(0);
}
